/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.web;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.platform.shibboleth.ShibbolethGroupHelper;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.webapp.security.AbstractUserGroupManagement;

@Name(value="shibbGroupManagerActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ShibbolethGroupManagerActionsBean
extends AbstractUserGroupManagement {
    protected static final String EVENT_SHIBB_GROUP_LISTING = "shibbGroupsListingChanged";
    protected static final String VIEW_SHIBB_GROUP = "view_shibbGroup";
    protected static final String VIEW_SHIBB_GROUPS = "view_shibbGroups";
    protected static final String EDIT_SHIBB_GROUP = "edit_shibbGroup";
    private static final long serialVersionUID = -2103588024105680788L;
    protected DocumentModel selectedGroup;
    protected DocumentModel newGroup;
    protected Boolean canEditGroups;
    @In(create=true)
    protected transient CoreSession documentManager;

    public void createGroup() throws ClientException {
        this.createGroup(false);
    }

    public void createGroup(boolean createAnotherGroup) throws ClientException {
        try {
            this.selectedGroup = ShibbolethGroupHelper.createGroup(this.newGroup);
            this.newGroup = null;
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("info.groupManager.groupCreated"), new Object[0]);
            if (createAnotherGroup) {
                this.showCreateForm = true;
            } else {
                this.showCreateForm = false;
                this.showUserOrGroup = true;
            }
            this.fireSeamEvent(EVENT_SHIBB_GROUP_LISTING);
        }
        catch (GroupAlreadyExistsException e) {
            String message = (String)this.resourcesAccessor.getMessages().get("error.groupManager.groupAlreadyExists");
            this.facesMessages.addToControl("groupName", StatusMessage.Severity.ERROR, message, new Object[0]);
        }
        catch (InvalidPropertyValueException e) {
            String message = (String)this.resourcesAccessor.getMessages().get("error.shibboleth.groupManager.wrongEl");
            this.facesMessages.addToControl("expressionLanguage", StatusMessage.Severity.ERROR, message, new Object[0]);
        }
    }

    public void deleteGroup() throws ClientException {
        ShibbolethGroupHelper.deleteGroup(this.selectedGroup);
        this.selectedGroup = null;
        this.showUserOrGroup = false;
        this.fireSeamEvent(EVENT_SHIBB_GROUP_LISTING);
    }

    public String editGroup() throws ClientException {
        this.selectedGroup = this.refreshGroup(this.selectedGroup.getId());
        return EDIT_SHIBB_GROUP;
    }

    protected String getTrimmedSearchString() {
        if (this.searchString == null) {
            return null;
        }
        return this.searchString.trim();
    }

    public DocumentModel getNewGroup() throws ClientException {
        if (this.newGroup == null) {
            this.newGroup = ShibbolethGroupHelper.getBareGroupModel(this.documentManager);
        }
        return this.newGroup;
    }

    public boolean isSelectedGroupReadOnly() {
        return false;
    }

    public void updateGroup() throws ClientException {
        try {
            ShibbolethGroupHelper.updateGroup(this.selectedGroup);
            this.detailsMode = "view";
            this.fireSeamEvent(EVENT_SHIBB_GROUP_LISTING);
        }
        catch (InvalidPropertyValueException e) {
            String message = (String)this.resourcesAccessor.getMessages().get("error.shibboleth.groupManager.wrongEl");
            this.facesMessages.addToControl("expressionLanguage", StatusMessage.Severity.ERROR, message, new Object[0]);
        }
    }

    public String viewGroup() throws ClientException {
        if (this.selectedGroup == null) {
            return null;
        }
        return this.viewGroup(this.selectedGroup, false);
    }

    public String viewGroup(String groupName) throws ClientException {
        this.setSelectedGroup(groupName);
        this.showUserOrGroup = true;
        return this.viewGroup(ShibbolethGroupHelper.getGroup(groupName), false);
    }

    protected DocumentModel refreshGroup(String groupName) throws ClientException {
        return ShibbolethGroupHelper.getGroup(groupName);
    }

    protected String viewGroup(DocumentModel group, boolean refresh) throws ClientException {
        if (group != null) {
            this.selectedGroup = group;
            if (refresh) {
                this.selectedGroup = this.refreshGroup(group.getId());
            }
            if (this.selectedGroup != null) {
                return VIEW_SHIBB_GROUP;
            }
        }
        return null;
    }

    public void clearSearch() {
        this.searchString = null;
        this.fireSeamEvent(EVENT_SHIBB_GROUP_LISTING);
    }

    protected boolean getCanEditGroups() throws ClientException {
        if (this.canEditGroups == null) {
            NuxeoPrincipal pal;
            this.canEditGroups = false;
            if (!this.userManager.areGroupsReadOnly().booleanValue() && this.currentUser instanceof NuxeoPrincipal && (pal = (NuxeoPrincipal)this.currentUser).isAdministrator()) {
                this.canEditGroups = true;
            }
        }
        return this.canEditGroups;
    }

    public boolean getAllowCreateGroup() throws ClientException {
        return this.getCanEditGroups();
    }

    public boolean getAllowDeleteGroup() throws ClientException {
        return this.getCanEditGroups() && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedGroup);
    }

    public boolean getAllowEditGroup() throws ClientException {
        return this.getCanEditGroups() && !BaseSession.isReadOnlyEntry((DocumentModel)this.selectedGroup);
    }

    protected String computeListingMode() throws ClientException {
        return this.userManager.getGroupListingMode();
    }

    public DocumentModel getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(String group) throws ClientException {
        this.selectedGroup = this.refreshGroup(group);
    }

    protected void fireSeamEvent(String eventName) {
        Events.instance().raiseEvent(eventName, new Object[0]);
    }

    @Observer(value={"shibbGroupsListingChanged"})
    public void onUsersListingChanged() {
        this.contentViewActions.refreshOnSeamEvent(EVENT_SHIBB_GROUP_LISTING);
        this.contentViewActions.resetPageProviderOnSeamEvent(EVENT_SHIBB_GROUP_LISTING);
    }
}

