/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.adapter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OccurrenceInfo {
    public final String mention;
    public final String context;
    public final int startPosInContext;
    public final int endPosInContext;

    public OccurrenceInfo(String mention, String context) {
        if (context == null || context.isEmpty()) {
            throw new IllegalArgumentException("Cannot build OccurrenceInfo instance without a context");
        }
        if (mention == null || mention.isEmpty()) {
            throw new IllegalArgumentException("Cannot build OccurrenceInfo instance without a mention");
        }
        if (!context.contains(mention)) {
            throw new IllegalArgumentException(String.format("'%s' should occur in context '%s'", mention, context));
        }
        this.context = context;
        this.mention = mention;
        this.startPosInContext = context.indexOf(mention);
        this.endPosInContext = this.startPosInContext + mention.length();
    }

    public OccurrenceInfo(String context, int startPosInContext, int endPosInContext) {
        if (context == null || context.isEmpty()) {
            throw new IllegalArgumentException("Cannot build OccurrenceInfo instance without a context");
        }
        if (startPosInContext >= endPosInContext) {
            throw new IllegalArgumentException(String.format("Start position %d must be larger that end position %d", startPosInContext, endPosInContext));
        }
        if (startPosInContext < 0) {
            throw new IllegalArgumentException(String.format("Start position %d must be zero or positive", startPosInContext));
        }
        if (endPosInContext > context.length()) {
            throw new IllegalArgumentException(String.format("End position %d must be smaller or equal to context length %d", endPosInContext, context.length()));
        }
        this.context = context;
        this.mention = context.substring(startPosInContext, endPosInContext);
        this.startPosInContext = startPosInContext;
        this.endPosInContext = endPosInContext;
    }

    public Map<String, Serializable> asQuoteyMap() {
        HashMap<String, Serializable> quote = new HashMap<String, Serializable>();
        quote.put("text", (Serializable)((Object)this.context));
        quote.put("startPos", new Long(this.startPosInContext));
        quote.put("endPos", new Long(this.endPosInContext));
        return quote;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.mention == null ? 0 : this.mention.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OccurrenceInfo other = (OccurrenceInfo)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.mention == null ? other.mention != null : !this.mention.equals(other.mention));
    }
}

