/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.jsf.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.semanticentities.DereferencingException;
import org.nuxeo.ecm.platform.semanticentities.EntitySuggestion;
import org.nuxeo.ecm.platform.semanticentities.LocalEntityService;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntity;
import org.nuxeo.ecm.platform.semanticentities.RemoteEntityService;
import org.nuxeo.ecm.platform.semanticentities.adapter.OccurrenceRelation;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="semanticEntitiesActions")
@Scope(value=ScopeType.CONVERSATION)
public class SemanticEntitiesActions {
    public static final Log log = LogFactory.getLog(SemanticEntitiesActions.class);
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(required=false)
    protected CoreSession documentManager;
    @In(create=true)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected String documentSuggestionKeywords;
    protected String selectedDocumentId;
    protected EntitySuggestion selectedEntitySuggestion;
    protected List<DocumentModel> documentSuggestions;
    protected LocalEntityService leService;
    protected boolean isRemoteEntitySearchDisplayed = false;
    protected URI selectedEntitySuggestionUri;
    protected String selectedEntitySuggestionLabel;

    protected LocalEntityService getLocalEntityService() throws Exception {
        if (this.leService == null) {
            this.leService = (LocalEntityService)Framework.getService(LocalEntityService.class);
        }
        return this.leService;
    }

    @Factory(scope=ScopeType.SESSION, value="canBrowseEntityContainer")
    public boolean getCanBrowseEntityContainer() throws Exception {
        return this.getLocalEntityService().getEntityContainer(this.documentManager) != null;
    }

    public String goToEntityContainer() throws Exception {
        DocumentModel entityContainer = this.getLocalEntityService().getEntityContainer(this.documentManager);
        if (entityContainer == null) {
            return null;
        }
        return this.navigationContext.navigateToDocument(entityContainer);
    }

    @Factory(scope=ScopeType.CONVERSATION, value="entityOccurrenceProvider")
    public PageProvider<DocumentModel> getCurrentEntityOccurrenceProvider() throws ClientException, Exception {
        return this.getEntityOccurrenceProvider(this.navigationContext.getCurrentDocument());
    }

    public PageProvider<DocumentModel> getEntityOccurrenceProvider(DocumentModel entity) throws ClientException, Exception {
        return this.getLocalEntityService().getRelatedDocuments(this.documentManager, entity.getRef(), null);
    }

    @Factory(scope=ScopeType.CONVERSATION, value="relatedPeopleProvider")
    public PageProvider<DocumentModel> getRelatedPeopleProvider() throws ClientException, Exception {
        return this.getRelatedEntitiesProvider(this.navigationContext.getCurrentDocument(), "Person");
    }

    @Factory(scope=ScopeType.CONVERSATION, value="relatedPlacesProvider")
    public PageProvider<DocumentModel> getRelatedPlacesProvider() throws ClientException, Exception {
        return this.getRelatedEntitiesProvider(this.navigationContext.getCurrentDocument(), "Place");
    }

    @Factory(scope=ScopeType.CONVERSATION, value="relatedOrganizationsProvider")
    public PageProvider<DocumentModel> getRelatedOrganizationsProvider() throws ClientException, Exception {
        return this.getRelatedEntitiesProvider(this.navigationContext.getCurrentDocument(), "Organization");
    }

    public PageProvider<DocumentModel> getRelatedEntitiesProvider(DocumentModel doc, String entityType) throws ClientException, Exception {
        return this.getLocalEntityService().getRelatedEntities(this.documentManager, doc.getRef(), entityType);
    }

    public List<DocumentModel> suggestDocuments(Object keywords) {
        try {
            return this.getLocalEntityService().suggestDocument(this.documentManager, keywords.toString(), null, 10);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.fetchingDocuments"), new Object[0]);
            return Collections.emptyList();
        }
    }

    public void setSelectedDocumentId(String selectedDocumentId) {
        this.selectedDocumentId = selectedDocumentId;
    }

    public List<EntitySuggestion> suggestEntities(Object keywords) {
        try {
            return this.getLocalEntityService().suggestEntity(this.documentManager, keywords.toString(), null, 10);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.fetchingEntities"), new Object[0]);
            return Collections.emptyList();
        }
    }

    public void setSelectedSuggestion(EntitySuggestion suggestion) {
        this.selectedEntitySuggestion = suggestion;
    }

    public void addNewOccurrenceRelation() {
        try {
            if (this.selectedDocumentId != null) {
                this.getLocalEntityService().addOccurrences(this.documentManager, (DocumentRef)new IdRef(this.selectedDocumentId), this.navigationContext.getCurrentDocument().getRef(), null);
            } else if (this.selectedEntitySuggestion != null) {
                DocumentModel localEntity = this.leService.asLocalEntity(this.documentManager, this.selectedEntitySuggestion);
                this.leService.addOccurrences(this.documentManager, this.navigationContext.getCurrentDocument().getRef(), localEntity.getRef(), null);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.addingRelation"), new Object[0]);
        }
        this.invalidateCurrentDocumentProviders();
    }

    public void removeOccurrenceRelation(String docId, String entityId) {
        try {
            OccurrenceRelation rel = this.getLocalEntityService().getOccurrenceRelation(this.documentManager, (DocumentRef)new IdRef(docId), (DocumentRef)new IdRef(entityId));
            if (rel != null) {
                DocumentModel relDoc = rel.getOccurrenceDocument();
                List<DocumentModel> docToDelete = Arrays.asList(relDoc);
                TrashService trashService = (TrashService)Framework.getService(TrashService.class);
                if (trashService.canDelete(docToDelete, this.documentManager.getPrincipal(), false)) {
                    trashService.trashDocuments(docToDelete);
                } else {
                    this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("error.removingRelation"), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.removingRelation"), new Object[0]);
        }
        this.invalidateCurrentDocumentProviders();
    }

    @Factory(scope=ScopeType.EVENT, value="currentEntitySameAs")
    public List<RemoteEntity> getCurrentEntitySameAs() {
        try {
            return RemoteEntity.fromDocument((DocumentModel)this.navigationContext.getCurrentDocument());
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.fetchingLocalLinkedEntities"), new Object[0]);
            return Collections.emptyList();
        }
    }

    public void showSuggestRemoteEntitySearch() {
        this.isRemoteEntitySearchDisplayed = true;
    }

    public boolean getShowSuggestRemoteEntitySearch() {
        return this.isRemoteEntitySearchDisplayed;
    }

    public List<RemoteEntity> suggestRemoteEntity(Object input) {
        String type = this.navigationContext.getCurrentDocument().getType();
        String keywords = (String)input;
        try {
            RemoteEntityService remoteEntityService = (RemoteEntityService)Framework.getService(RemoteEntityService.class);
            ArrayList<RemoteEntity> filteredSuggestions = new ArrayList<RemoteEntity>();
            List suggestions = remoteEntityService.suggestRemoteEntity(keywords, type, 5);
            filteredSuggestions.addAll(suggestions);
            return filteredSuggestions;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.fetchingRemoteEntities"), new Object[0]);
            return Collections.emptyList();
        }
    }

    public void setSelectedEntitySuggestionUri(URI uri) {
        this.selectedEntitySuggestionUri = uri;
    }

    public void setSelectedEntitySuggestionLabel(String label) {
        this.selectedEntitySuggestionLabel = label;
    }

    public void addRemoteEntityLinkAndSync() {
        if (this.selectedEntitySuggestionLabel == null || this.selectedEntitySuggestionUri == null) {
            return;
        }
        RemoteEntity re = new RemoteEntity(this.selectedEntitySuggestionLabel, this.selectedEntitySuggestionUri);
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        try {
            this.syncAndSaveDocument(doc, re.uri, true);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.linkingToRemoteEntity"), new Object[0]);
        }
        Contexts.removeFromAllContexts((String)"currentEntitySameAs");
    }

    public void syncWithSameAsLink(String uri) {
        try {
            this.syncAndSaveDocument(this.navigationContext.getChangeableDocument(), URI.create(uri), true);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.syncingWithRemoteEntity"), new Object[0]);
        }
    }

    protected void syncAndSaveDocument(DocumentModel doc, URI uri, boolean fullSync) throws Exception, DereferencingException, ClientException {
        RemoteEntityService remoteEntityService = (RemoteEntityService)Framework.getService(RemoteEntityService.class);
        if (remoteEntityService.canDereference(uri)) {
            remoteEntityService.dereferenceInto(doc, uri, fullSync);
        }
        doc = this.documentManager.saveDocument(doc);
        this.documentManager.save();
        this.notifyDocumentUpdated(doc);
    }

    public void removeSameAsLink(String uri) {
        try {
            DocumentModel doc = this.navigationContext.getChangeableDocument();
            RemoteEntityService remoteEntityService = (RemoteEntityService)Framework.getService(RemoteEntityService.class);
            remoteEntityService.removeSameAsLink(doc, URI.create(uri));
            doc = this.documentManager.saveDocument(doc);
            this.documentManager.save();
            this.notifyDocumentUpdated(doc);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, this.messages.get("error.unlinkingRemoteEntity"), new Object[0]);
        }
        Contexts.removeFromAllContexts((String)"currentEntitySameAs");
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    public void onDocumentNavigation() {
        this.selectedDocumentId = null;
        this.selectedEntitySuggestion = null;
        this.isRemoteEntitySearchDisplayed = false;
        this.invalidateCurrentDocumentProviders();
    }

    public void invalidateCurrentDocumentProviders() {
        Contexts.removeFromAllContexts((String)"entityOccurrenceProvider");
        Contexts.removeFromAllContexts((String)"relatedPlacesProvider");
        Contexts.removeFromAllContexts((String)"relatedPeopleProvider");
        Contexts.removeFromAllContexts((String)"relatedOrganizationsProvider");
    }

    protected void notifyDocumentUpdated(DocumentModel doc) throws ClientException {
        this.navigationContext.invalidateCurrentDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_modified"), new Object[]{this.messages.get(doc.getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)doc);
    }

    public String ellipsis(String content, int maxSize) {
        if (content == null) {
            return "";
        }
        if (content.length() > maxSize) {
            return content.substring(0, maxSize) + "[...]";
        }
        return content;
    }
}

