/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.semanticentities.listener;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.platform.semanticentities.extraction.OccurrenceExtractionOperation;

public class SemanticEntitiesCoreListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(SemanticEntitiesCoreListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        CoreSession session = null;
        HashSet<String> ids = new HashSet<String>();
        for (Event event : events) {
            if (!event.getName().equals("documentModified") && !event.getName().equals("documentCreated")) continue;
            EventContext eventContext = event.getContext();
            CoreSession s = eventContext.getCoreSession();
            ids.add(((DocumentModel)eventContext.getArguments()[0]).getId());
            if (session == null) {
                session = s;
                continue;
            }
            if (session == s) continue;
            throw new ClientException("Several CoreSessions in one EventBundle");
        }
        if (session == null) {
            if (ids.isEmpty()) {
                return;
            }
            throw new ClientException("Missing CoreSession");
        }
        for (Serializable serializable : ids) {
            DocumentModel doc;
            IdRef docRef = new IdRef((String)((Object)serializable));
            if (session.getPrincipal() == null || !session.exists((DocumentRef)docRef) || (doc = session.getDocument((DocumentRef)docRef)).isProxy()) continue;
            try {
                OccurrenceExtractionOperation op = new OccurrenceExtractionOperation(session);
                op.run(doc);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

