/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.sso;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.nuxeo.ecm.platform.auth.saml.AbstractSAMLProfile;
import org.nuxeo.ecm.platform.auth.saml.SAMLConfiguration;
import org.nuxeo.ecm.platform.auth.saml.SAMLCredential;
import org.nuxeo.ecm.platform.auth.saml.sso.WebSSOProfile;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.EncryptedAttribute;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.signature.Signature;

public class WebSSOProfileImpl
extends AbstractSAMLProfile
implements WebSSOProfile {
    public WebSSOProfileImpl(SingleSignOnService sso) {
        super((Endpoint)sso);
    }

    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:browser";
    }

    @Override
    public SAMLCredential processAuthenticationResponse(SAMLMessageContext context) throws SAMLException {
        SAMLObject message = context.getInboundSAMLMessage();
        if (!(message instanceof Response)) {
            log.debug((Object)"Received response is not of a Response object type");
            throw new SAMLException("Received response is not of a Response object type");
        }
        Response response = (Response)message;
        String statusCode = response.getStatus().getStatusCode().getValue();
        if (!StringUtils.equals((CharSequence)statusCode, (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
            log.debug((Object)("StatusCode was not a success: " + statusCode));
            throw new SAMLException("StatusCode was not a success: " + statusCode);
        }
        if (response.getSignature() != null) {
            log.debug((Object)"Verifying message signature");
            this.validateSignature(response.getSignature(), context.getPeerEntityId());
            context.setInboundSAMLMessageAuthenticated(true);
        }
        if (response.getIssuer() != null) {
            log.debug((Object)"Verifying issuer of the message");
            Issuer issuer = response.getIssuer();
            this.validateIssuer(issuer, context);
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List assertions = response.getAssertions();
        List encryptedAssertionList = response.getEncryptedAssertions();
        for (EncryptedAssertion ea : encryptedAssertionList) {
            try {
                log.debug((Object)"Decrypting assertion");
                assertions.add(this.getDecrypter().decrypt(ea));
            }
            catch (DecryptionException e) {
                log.debug((Object)"Decryption of received assertion failed, assertion will be skipped", (Throwable)e);
            }
        }
        Subject subject = null;
        ArrayList<String> sessionIndexes = new ArrayList<String>();
        for (Assertion a : assertions) {
            if (a.getAuthnStatements().size() > 0) {
                try {
                    this.validateAssertion(a, context);
                    for (AuthnStatement statement : a.getAuthnStatements()) {
                        sessionIndexes.add(statement.getSessionIndex());
                    }
                }
                catch (SAMLException e) {
                    log.debug((Object)"Validation of received assertion failed, assertion will be skipped", (Throwable)e);
                    continue;
                }
            }
            subject = a.getSubject();
            for (AttributeStatement attStatement : a.getAttributeStatements()) {
                for (Attribute att : attStatement.getAttributes()) {
                    attributes.add(att);
                }
                for (Attribute att : attStatement.getEncryptedAttributes()) {
                    try {
                        attributes.add(this.getDecrypter().decrypt((EncryptedAttribute)att));
                    }
                    catch (DecryptionException e) {
                        log.error((Object)"Failed to decrypt assertion");
                    }
                }
            }
        }
        if (subject == null) {
            log.debug((Object)"Response doesn't have any valid assertion which would pass subject validation");
            throw new SAMLException("Error validating SAML response");
        }
        NameID nameID = null;
        if (subject.getEncryptedID() == null) {
            nameID = subject.getNameID();
        }
        if (nameID == null) {
            log.debug((Object)"NameID element must be present as part of the Subject in the Response message, please enable it in the IDP configuration");
            throw new SAMLException("NameID element must be present as part of the Subject in the Response message, please enable it in the IDP configuration");
        }
        Serializable additionalData = null;
        return new SAMLCredential(nameID, sessionIndexes, context.getPeerEntityMetadata().getEntityID(), context.getRelayState(), attributes, context.getLocalEntityId(), additionalData);
    }

    @Override
    public AuthnRequest buildAuthRequest(HttpServletRequest httpRequest, String ... authnContexts) throws SAMLException {
        AuthnRequest request = (AuthnRequest)this.build(AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setID(this.newUUID());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(new DateTime());
        request.setAssertionConsumerServiceURL(this.getStartPageURL((ServletRequest)httpRequest));
        Issuer issuer = (Issuer)this.build(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(SAMLConfiguration.getEntityId());
        request.setIssuer(issuer);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)this.build(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        request.setNameIDPolicy(nameIDPolicy);
        if (authnContexts.length > 0) {
            RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)this.build(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            request.setRequestedAuthnContext(requestedAuthnContext);
            for (String context : authnContexts) {
                AuthnContextClassRef authnContextClassRef = (AuthnContextClassRef)this.build(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
                authnContextClassRef.setAuthnContextClassRef(context);
                requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
            }
        }
        return request;
    }

    @Override
    protected void validateAssertion(Assertion assertion, SAMLMessageContext context) throws SAMLException {
        SPSSODescriptor roleMetadata;
        super.validateAssertion(assertion, context);
        Signature signature = assertion.getSignature();
        if (signature == null && (roleMetadata = (SPSSODescriptor)context.getLocalEntityRoleMetadata()) != null && roleMetadata.getWantAssertionsSigned().booleanValue() && !context.isInboundSAMLMessageAuthenticated()) {
            throw new SAMLException("Metadata includes wantAssertionSigned, but neither Response nor included Assertion is signed");
        }
    }
}

