/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.binding;

import org.nuxeo.ecm.platform.auth.saml.binding.SAMLBinding;
import org.opensaml.common.SAMLException;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;

public class HTTPRedirectBinding
extends SAMLBinding {
    public static final String SAML_REQUEST = "SAMLRequest";
    public static final String SAML_RESPONSE = "SAMLResponse";

    public HTTPRedirectBinding() {
        super((MessageDecoder)new HTTPRedirectDeflateDecoder(), (MessageEncoder)new DeflateEncoder());
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Override
    public boolean supports(InTransport transport) {
        if (transport instanceof HTTPInTransport) {
            HTTPTransport t = (HTTPTransport)transport;
            return "GET".equalsIgnoreCase(t.getHTTPMethod()) && (t.getParameterValue(SAML_REQUEST) != null || t.getParameterValue(SAML_RESPONSE) != null);
        }
        return false;
    }

    @Override
    public boolean supports(OutTransport transport) {
        return transport instanceof HTTPOutTransport;
    }

    public String buildRedirectURL(SAMLMessageContext context, String endpointURL) throws SAMLException {
        return ((DeflateEncoder)this.encoder).buildRedirectURL(context, endpointURL);
    }

    private static class DeflateEncoder
    extends HTTPRedirectDeflateEncoder {
        private DeflateEncoder() {
        }

        public String buildRedirectURL(SAMLMessageContext context, String endpointURL) throws SAMLException {
            this.removeSignature(context);
            try {
                String encodedMessage = this.deflateAndBase64Encode(context.getOutboundSAMLMessage());
                return this.buildRedirectURL(context, endpointURL, encodedMessage);
            }
            catch (MessageEncodingException e) {
                throw new SAMLException("Failed to build redirect URL", (Exception)((Object)e));
            }
        }
    }
}

