/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.usermapper.extension.UserMapper;
import org.nuxeo.usermapper.service.UserMapperDescriptor;
import org.nuxeo.usermapper.service.UserMapperService;

public class UserMapperComponent
extends DefaultComponent
implements UserMapperService {
    protected static final Log log = LogFactory.getLog(UserMapperComponent.class);
    protected Map<String, UserMapper> mappers = new HashMap<String, UserMapper>();
    protected List<UserMapperDescriptor> descriptors = new ArrayList<UserMapperDescriptor>();
    public static final String MAPPER_EP = "mapper";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MAPPER_EP.equalsIgnoreCase(extensionPoint)) {
            UserMapperDescriptor desc = (UserMapperDescriptor)contribution;
            this.descriptors.add(desc);
        }
    }

    public void applicationStarted(ComponentContext context) {
        for (UserMapperDescriptor desc : this.descriptors) {
            try {
                this.mappers.put(desc.name, desc.getInstance());
            }
            catch (Exception e) {
                log.error((Object)("Unable to register mapper " + desc.name), (Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (MAPPER_EP.equalsIgnoreCase(extensionPoint)) {
            UserMapperDescriptor desc = (UserMapperDescriptor)contribution;
            UserMapper um = this.mappers.get(desc.name);
            if (um != null) {
                um.release();
                this.mappers.remove(desc.name);
            }
        }
    }

    public void deactivate(ComponentContext context) {
        for (UserMapper um : this.mappers.values()) {
            um.release();
        }
        super.deactivate(context);
    }

    @Override
    public UserMapper getMapper(String mappingName) throws NuxeoException {
        UserMapper um = this.mappers.get(mappingName);
        if (um == null) {
            throw new NuxeoException("No mapping defined for " + mappingName);
        }
        return um;
    }

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(String mappingName, Object userObject) throws NuxeoException {
        return this.getOrCreateAndUpdateNuxeoPrincipal(mappingName, userObject, true, true, null);
    }

    @Override
    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(String mappingName, Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) throws NuxeoException {
        return this.getMapper(mappingName).getOrCreateAndUpdateNuxeoPrincipal(userObject, createIfNeeded, update, params);
    }

    @Override
    public Object wrapNuxeoPrincipal(String mappingName, NuxeoPrincipal principal, Object nativePrincipal, Map<String, Serializable> params) throws NuxeoException {
        return this.getMapper(mappingName).wrapNuxeoPrincipal(principal, nativePrincipal, params);
    }

    @Override
    public Set<String> getAvailableMappings() {
        return this.mappers.keySet();
    }
}

