/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.apidoc.introspection.ComponentInfoImpl;
import org.nuxeo.apidoc.introspection.ExtensionInfoImpl;

@JsonIgnoreType
public class ExtensionPointInfoImpl
extends BaseNuxeoArtifact
implements ExtensionPointInfo {
    protected final ComponentInfoImpl component;
    protected final String name;
    protected final Collection<ExtensionInfo> extensions = new ArrayList<ExtensionInfo>();
    protected final List<Class<?>> spi = new ArrayList();
    protected String[] descriptors;
    protected String documentation;

    public ExtensionPointInfoImpl(ComponentInfoImpl component, String name) {
        this.name = name;
        this.component = component;
    }

    @Override
    public ComponentInfoImpl getComponent() {
        return this.component;
    }

    @Override
    public String getComponentId() {
        return this.component.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescriptors(String[] descriptors) {
        this.descriptors = descriptors;
    }

    @Override
    public String[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public Collection<ExtensionInfo> getExtensions() {
        return this.extensions;
    }

    public void addExtension(ExtensionInfoImpl xt) {
        this.extensions.add(xt);
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    public void addSpi(List<Class<?>> spi) {
        this.spi.addAll(spi);
    }

    @Override
    public String getId() {
        return this.component.getId() + "--" + this.name;
    }

    @Override
    public String getVersion() {
        return this.component.getVersion();
    }

    @Override
    public String getArtifactType() {
        return "NXExtensionPoint";
    }

    @Override
    public String getLabel() {
        return this.name + " (" + this.component.getId() + ")";
    }

    @Override
    public String getHierarchyPath() {
        return this.component.getHierarchyPath() + "/" + "ExtensionPoints" + "/" + this.getId();
    }
}

