/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.documentation.AssociatedDocumentsImpl;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.apidoc.introspection.ComponentInfoImpl;
import org.nuxeo.ecm.core.api.CoreSession;

public class BundleInfoImpl
extends BaseNuxeoArtifact
implements BundleInfo {
    protected final String bundleId;
    protected final Collection<ComponentInfo> components;
    protected String fileName;
    protected String manifest;
    protected String[] requirements;
    protected String groupId;
    protected String artifactId;
    protected String artifactVersion;
    protected BundleGroup bundleGroup;
    protected Map<String, ResourceDocumentationItem> liveDoc;
    protected Map<String, ResourceDocumentationItem> parentLiveDoc;
    protected String location;

    public BundleGroup getBundleGroup() {
        return this.bundleGroup;
    }

    public void setBundleGroup(BundleGroup bundleGroup) {
        this.bundleGroup = bundleGroup;
    }

    public BundleInfoImpl(String bundleId) {
        this.bundleId = bundleId;
        this.components = new ArrayList<ComponentInfo>();
    }

    @Override
    public Collection<ComponentInfo> getComponents() {
        return this.components;
    }

    public void addComponent(ComponentInfoImpl component) {
        this.components.add(component);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getBundleId() {
        return this.bundleId;
    }

    @Override
    public String[] getRequirements() {
        return this.requirements;
    }

    public void setRequirements(String[] requirements) {
        this.requirements = requirements;
    }

    @Override
    public String getManifest() {
        return this.manifest;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getArtifactGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    @Override
    public String getId() {
        return this.bundleId;
    }

    @Override
    public String getVersion() {
        return this.artifactVersion;
    }

    @Override
    public String getArtifactType() {
        return "NXBundle";
    }

    @Override
    public String getHierarchyPath() {
        return this.bundleGroup.getHierarchyPath() + "/" + this.getId();
    }

    public void setLiveDoc(Map<String, ResourceDocumentationItem> liveDoc) {
        this.liveDoc = liveDoc;
    }

    public void setParentLiveDoc(Map<String, ResourceDocumentationItem> parentLiveDoc) {
        this.parentLiveDoc = parentLiveDoc;
    }

    protected Map<String, ResourceDocumentationItem> getMergedDocumentation() {
        Map<String, ResourceDocumentationItem> merged = this.parentLiveDoc;
        if (merged == null) {
            merged = new HashMap<String, ResourceDocumentationItem>();
        }
        if (this.liveDoc != null) {
            for (String key : this.liveDoc.keySet()) {
                if (this.liveDoc.get(key) == null) continue;
                merged.put(key, this.liveDoc.get(key));
            }
        }
        return merged;
    }

    @Override
    public AssociatedDocumentsImpl getAssociatedDocuments(CoreSession session) {
        AssociatedDocumentsImpl docs = super.getAssociatedDocuments(session);
        docs.setLiveDoc(this.getMergedDocumentation());
        return docs;
    }

    public Map<String, ResourceDocumentationItem> getLiveDoc() {
        return this.liveDoc;
    }

    public Map<String, ResourceDocumentationItem> getParentLiveDoc() {
        return this.parentLiveDoc;
    }
}

