/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.AbstractDocumentationItem;
import org.nuxeo.apidoc.api.AssociatedDocuments;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.documentation.DefaultDocumentationType;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;

public class AssociatedDocumentsImpl
implements AssociatedDocuments {
    protected String id;
    protected final NuxeoArtifact item;
    protected final CoreSession session;
    protected Map<String, ResourceDocumentationItem> liveDoc;
    protected final Log log = LogFactory.getLog(AssociatedDocumentsImpl.class);

    public AssociatedDocumentsImpl(NuxeoArtifact item, CoreSession session) {
        this.item = item;
        this.session = session;
    }

    @Override
    public Map<String, List<DocumentationItem>> getDocumentationItems(CoreSession session) {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        List<DocumentationItem> docItems = ds.findDocumentItems(session, this.item);
        Map<String, String> categories = this.getCategories();
        LinkedHashMap<String, List<DocumentationItem>> result = new LinkedHashMap<String, List<DocumentationItem>>();
        ArrayList<String> empty = new ArrayList<String>();
        for (String catLabel : categories.values()) {
            result.put(catLabel, new ArrayList());
            empty.add(catLabel);
        }
        for (DocumentationItem docItem : docItems) {
            String cat = docItem.getType();
            String catLabel = categories.get(cat);
            ((List)result.get(catLabel)).add(docItem);
            empty.remove(catLabel);
        }
        if (this.liveDoc != null) {
            for (String vCat : this.liveDoc.keySet()) {
                String catLabel = categories.get(vCat);
                if (result.get(catLabel) != null) {
                    ((List)result.get(catLabel)).add(this.liveDoc.get(vCat));
                    empty.remove(catLabel);
                    continue;
                }
                this.log.warn((Object)("Live doc for category " + catLabel + " won't be visible"));
            }
        }
        for (String catLabel : empty) {
            result.remove(catLabel);
        }
        return result;
    }

    @Override
    public Map<String, String> getCategories() {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        return ds.getCategories();
    }

    @Override
    public List<String> getCategoryKeys() {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        return ds.getCategoryKeys();
    }

    @Override
    public DocumentationItem getDescription(CoreSession session) {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        List<DocumentationItem> docItems = ds.findDocumentItems(session, this.item);
        for (DocumentationItem docItem : docItems) {
            String cat = docItem.getType();
            if (!DefaultDocumentationType.DESCRIPTION.getValue().equals(cat)) continue;
            return docItem;
        }
        return new AbstractDocumentationItem(){

            @Override
            public boolean isApproved() {
                return false;
            }

            @Override
            public String getUUID() {
                return null;
            }

            @Override
            public String getTypeLabel() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public String getTitle() {
                String id;
                String[] parts;
                if (AssociatedDocumentsImpl.this.item.getArtifactType().equals("NXExtensionPoint")) {
                    return ((ExtensionPointInfo)AssociatedDocumentsImpl.this.item).getName();
                }
                if (AssociatedDocumentsImpl.this.item.getArtifactType().equals("NXContribution")) {
                    return ((ExtensionInfo)AssociatedDocumentsImpl.this.item).getExtensionPoint();
                }
                if (AssociatedDocumentsImpl.this.item.getArtifactType().equals("NXService") && (parts = (id = AssociatedDocumentsImpl.this.item.getId()).split("\\.")).length > 1) {
                    String name = parts[parts.length - 1];
                    return name;
                }
                return AssociatedDocumentsImpl.this.item.getId();
            }

            @Override
            public String getTargetType() {
                return AssociatedDocumentsImpl.this.item.getArtifactType();
            }

            @Override
            public String getTarget() {
                return AssociatedDocumentsImpl.this.item.getId();
            }

            @Override
            public String getRenderingType() {
                return "html";
            }

            @Override
            public String getId() {
                return null;
            }

            @Override
            public String getContent() {
                String content = AssociatedDocumentsImpl.this.liveDoc.get(DefaultDocumentationType.DESCRIPTION.getValue()).getContent();
                if (content == null) {
                    content = "";
                }
                return content;
            }

            @Override
            public List<String> getApplicableVersion() {
                return null;
            }

            @Override
            public Map<String, String> getAttachments() {
                return new HashMap<String, String>();
            }

            @Override
            public boolean isPlaceHolder() {
                return true;
            }

            @Override
            public String getEditId() {
                return "placeholder_" + AssociatedDocumentsImpl.this.item.getId();
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        };
    }

    public void setLiveDoc(Map<String, ResourceDocumentationItem> liveDoc) {
        this.liveDoc = liveDoc;
    }
}

