/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.browse.ComponentWO;
import org.nuxeo.apidoc.browse.NuxeoArtifactWebObject;
import org.nuxeo.ecm.webengine.model.WebObject;

@WebObject(type="bundle")
public class BundleWO
extends NuxeoArtifactWebObject {
    @Override
    @GET
    @Produces(value={"text/html"})
    @Path(value="introspection")
    public Object doGet() {
        BundleInfo bi = this.getTargetBundleInfo();
        Collection ci = bi.getComponents();
        return this.getView("view").arg("bundle", (Object)bi).arg("components", (Object)ci);
    }

    public BundleInfo getTargetBundleInfo() {
        return this.getSnapshotManager().getSnapshot(this.getDistributionId(), this.ctx.getCoreSession()).getBundle(this.nxArtifactId);
    }

    @Override
    public NuxeoArtifact getNxArtifact() {
        return this.getTargetBundleInfo();
    }

    public List<ComponentWO> getComponents() {
        ArrayList<ComponentWO> result = new ArrayList<ComponentWO>();
        BundleInfo bundle = this.getTargetBundleInfo();
        ArrayList cis = new ArrayList(bundle.getComponents());
        Collections.sort(cis, new ComponentInfoSorter());
        for (ComponentInfo ci : cis) {
            result.add((ComponentWO)this.ctx.newObject("component", new Object[]{ci.getId()}));
        }
        return result;
    }

    protected class ComponentInfoSorter
    implements Comparator<ComponentInfo> {
        protected ComponentInfoSorter() {
        }

        @Override
        public int compare(ComponentInfo ci0, ComponentInfo ci1) {
            if (ci0.isXmlPureComponent() && !ci1.isXmlPureComponent()) {
                return 1;
            }
            if (!ci0.isXmlPureComponent() && ci1.isXmlPureComponent()) {
                return -1;
            }
            return ci0.getId().compareTo(ci1.getId());
        }
    }
}

