/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree;

import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;
import org.nuxeo.ecm.webengine.ui.tree.TreeItemVisitor;

public class TreeItemImpl
implements TreeItem {
    private static final long serialVersionUID = 5252830785508229998L;
    public static final int F_CONTAINER = 4;
    public static final int F_EXPANDED = 8;
    public static final TreeItem[] EMPTY_CHILDREN = new TreeItem[0];
    public static final TreeItem[] HAS_CHILDREN = new TreeItem[0];
    protected final ContentProvider provider;
    protected final TreeItem parent;
    protected final Path path;
    protected String label;
    protected String[] facets;
    protected TreeItem[] children = EMPTY_CHILDREN;
    protected final Object obj;
    protected volatile int state = 3;

    public TreeItemImpl(TreeItem parent, ContentProvider provider, Object data) {
        this.parent = parent;
        this.provider = provider;
        this.obj = data;
        String name = provider.getName(this.obj);
        this.path = parent != null ? parent.getPath().append(name) : new Path("/");
        if (provider.isContainer(this.obj)) {
            this.state |= 4;
        }
    }

    public TreeItemImpl(ContentProvider provider, Object data) {
        this(null, provider, data);
    }

    public TreeItemImpl(TreeItem parent, Object data) {
        this(parent, parent.getContentProvider(), data);
    }

    @Override
    public boolean hasChildren() {
        return this.children.length > 0;
    }

    @Override
    public TreeItem[] getChildren() {
        this.validateChildren();
        return this.children;
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public TreeItem getParent() {
        return this.parent;
    }

    @Override
    public ContentProvider getContentProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public String getLabel() {
        this.validateData();
        return this.label;
    }

    public String[] getFacets() {
        this.validateData();
        return this.facets;
    }

    @Override
    public boolean isContainer() {
        return (this.state & 4) != 0;
    }

    @Override
    public TreeItem find(Path path) {
        TreeItem item = this;
        int len = path.segmentCount() - 1;
        for (int i = 0; i < len; ++i) {
            if (!item.hasChildren()) {
                return null;
            }
            if ((item = item.getChild(path.segment(i))) != null) continue;
            return null;
        }
        if (!item.hasChildren()) {
            return null;
        }
        return item.getChild(path.lastSegment());
    }

    @Override
    public TreeItem findAndReveal(Path path) {
        TreeItem item = this;
        int len = path.segmentCount();
        for (int i = 0; i < len; ++i) {
            item.expand();
            item = item.getChild(path.segment(i));
            if (item != null) continue;
            return null;
        }
        return item;
    }

    @Override
    public TreeItem getChild(String name) {
        this.validateChildren();
        return this._getChild(name);
    }

    protected TreeItem _getChild(String name) {
        for (TreeItem child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public TreeItem[] expand() {
        if (this.isExpanded()) {
            return this.children;
        }
        if (this.parent != null && !this.parent.isExpanded()) {
            this.parent.expand();
        }
        this.state |= 8;
        return this.getChildren();
    }

    protected void loadData() {
        this.label = this.provider.getLabel(this.obj);
        this.facets = this.provider.getFacets(this.obj);
    }

    public void validateData() {
        if ((this.state & 1) != 0) {
            this.loadData();
            this.state &= 0xFFFFFFFE;
        }
    }

    public void validateChildren() {
        if ((this.state & 2) != 0) {
            this.loadChildren();
            this.state &= 0xFFFFFFFD;
        }
    }

    protected void loadChildren() {
        Object[] objects;
        if (!this.isContainer()) {
            return;
        }
        Object[] objectArray = objects = this.parent == null ? this.provider.getElements(this.obj) : this.provider.getChildren(this.obj);
        if (objects == null) {
            this.children = null;
        } else {
            this.children = new TreeItemImpl[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                this.children[i] = new TreeItemImpl(this, objects[i]);
            }
        }
    }

    @Override
    public void collapse() {
        this.state &= 0xFFFFFFF7;
    }

    @Override
    public boolean isExpanded() {
        return (this.state & 8) != 0;
    }

    @Override
    public void refresh(int type) {
        if ((type & 1) != 0) {
            this.loadData();
        }
        if ((type & 2) != 0) {
            this.loadChildren();
        }
        this.state &= ~type;
    }

    @Override
    public void validate() {
        this.refresh(this.state);
    }

    @Override
    public void invalidate(int type) {
        this.state |= type;
    }

    @Override
    public int getValidationState() {
        return this.state;
    }

    @Override
    public Object accept(TreeItemVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "TreeItem: " + this.obj.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TreeItem) {
            return this.getObject().equals(((TreeItem)obj).getObject());
        }
        return false;
    }
}

