/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.snapshot;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.introspection.RuntimeSnapshot;
import org.nuxeo.apidoc.repository.RepositoryDistributionSnapshot;
import org.nuxeo.apidoc.repository.SnapshotPersister;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.DistributionSnapshotDesc;
import org.nuxeo.apidoc.snapshot.SnapshotFilter;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.runtime.model.DefaultComponent;

public class SnapshotManagerComponent
extends DefaultComponent
implements SnapshotManager {
    protected DistributionSnapshot runtimeSnapshot;
    public static final String RUNTIME = "current";
    public static final String RUNTIME_ADM = "adm";
    protected static final Log log = LogFactory.getLog(SnapshotManagerComponent.class);
    protected final SnapshotPersister persister = new SnapshotPersister();

    @Override
    public DistributionSnapshot getRuntimeSnapshot() {
        if (this.runtimeSnapshot == null) {
            this.runtimeSnapshot = new RuntimeSnapshot();
        }
        return this.runtimeSnapshot;
    }

    @Override
    public DistributionSnapshot getSnapshot(String key, CoreSession session) {
        DistributionSnapshot rtsnap;
        if (key == null || RUNTIME.equals(key) || RUNTIME_ADM.equals(key)) {
            return this.getRuntimeSnapshot();
        }
        DistributionSnapshot snap = this.getPersistentSnapshots(session).get(key);
        if (snap == null && (rtsnap = this.getRuntimeSnapshot()).getKey().equals(key)) {
            return rtsnap;
        }
        return snap;
    }

    @Override
    public List<DistributionSnapshot> readPersistentSnapshots(CoreSession session) {
        List<DistributionSnapshot> snaps = RepositoryDistributionSnapshot.readPersistentSnapshots(session);
        return snaps;
    }

    @Override
    public List<DistributionSnapshot> listPersistentSnapshots(CoreSession session) {
        List<DistributionSnapshot> distribs = this.readPersistentSnapshots(session);
        Collections.sort(distribs, new Comparator<DistributionSnapshot>(){

            @Override
            public int compare(DistributionSnapshot dist0, DistributionSnapshot dist1) {
                if (dist0.getVersion().equals(dist1.getVersion())) {
                    return dist0.getName().compareTo(dist1.getName());
                }
                return -dist0.getVersion().compareTo(dist1.getVersion());
            }
        });
        return distribs;
    }

    @Override
    public Map<String, DistributionSnapshot> getPersistentSnapshots(CoreSession session) {
        HashMap<String, DistributionSnapshot> persistentSnapshots = new HashMap<String, DistributionSnapshot>();
        for (DistributionSnapshot snap : this.readPersistentSnapshots(session)) {
            persistentSnapshots.put(snap.getKey(), snap);
        }
        return persistentSnapshots;
    }

    @Override
    public List<String> getPersistentSnapshotNames(CoreSession session) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.getPersistentSnapshots(session).keySet());
        return names;
    }

    @Override
    public List<DistributionSnapshotDesc> getAvailableDistributions(CoreSession session) {
        ArrayList<DistributionSnapshotDesc> names = new ArrayList<DistributionSnapshotDesc>();
        names.addAll(this.getPersistentSnapshots(session).values());
        names.add(0, this.getRuntimeSnapshot());
        return names;
    }

    @Override
    public DistributionSnapshot persistRuntimeSnapshot(CoreSession session) throws ClientException {
        return this.persistRuntimeSnapshot(session, null);
    }

    @Override
    public DistributionSnapshot persistRuntimeSnapshot(CoreSession session, String name) throws ClientException {
        return this.persistRuntimeSnapshot(session, name, null);
    }

    @Override
    public DistributionSnapshot persistRuntimeSnapshot(CoreSession session, String name, SnapshotFilter filter) throws ClientException {
        DistributionSnapshot liveSnapshot = this.getRuntimeSnapshot();
        DistributionSnapshot snap = this.persister.persist(liveSnapshot, session, name, filter);
        this.addPersistentSnapshot(snap.getKey(), snap);
        return snap;
    }

    @Override
    public List<String> getAvailableVersions(CoreSession session, NuxeoArtifact nxItem) {
        ArrayList<String> versions = new ArrayList<String>();
        ArrayList<DistributionSnapshot> distribs = new ArrayList<DistributionSnapshot>();
        distribs.addAll(this.getPersistentSnapshots(session).values());
        distribs.add(this.getRuntimeSnapshot());
        for (DistributionSnapshot snap : distribs) {
            OperationInfo oi;
            String version = null;
            if ("NXBundleGroup".equals(nxItem.getArtifactType())) {
                BundleGroup bg = snap.getBundleGroup(nxItem.getId());
                if (bg != null) {
                    version = bg.getVersion();
                }
            } else if ("NXBundle".equals(nxItem.getArtifactType())) {
                BundleInfo bi = snap.getBundle(nxItem.getId());
                if (bi != null) {
                    version = bi.getVersion();
                }
            } else if ("NXComponent".equals(nxItem.getArtifactType())) {
                ComponentInfo ci = snap.getComponent(nxItem.getId());
                if (ci != null) {
                    version = ci.getVersion();
                }
            } else if ("NXContribution".equals(nxItem.getArtifactType())) {
                ExtensionInfo ei = snap.getContribution(nxItem.getId());
                if (ei != null) {
                    version = ei.getVersion();
                }
            } else if ("NXExtensionPoint".equals(nxItem.getArtifactType())) {
                ExtensionPointInfo epi = snap.getExtensionPoint(nxItem.getId());
                if (epi != null) {
                    version = epi.getVersion();
                }
            } else if ("NXService".equals(nxItem.getArtifactType())) {
                ServiceInfo si = snap.getService(nxItem.getId());
                if (si != null) {
                    version = si.getVersion();
                }
            } else if ("NXOperation".equals(nxItem.getArtifactType()) && (oi = snap.getOperation(nxItem.getId())) != null) {
                version = oi.getVersion();
            }
            if (version == null || versions.contains(version)) continue;
            versions.add(version);
        }
        return versions;
    }

    @Override
    public void exportSnapshot(CoreSession session, String key, OutputStream out) throws Exception {
        DistributionSnapshot snap = this.getSnapshot(key, session);
        if (snap == null) {
            throw new Exception("Unable to find Snapshot " + key);
        }
        if (snap.isLive()) {
            throw new Exception("Can not export a live distribution snapshot : " + key);
        }
        RepositoryDistributionSnapshot docSnap = (RepositoryDistributionSnapshot)snap;
        DocumentModel root = docSnap.getDoc();
        DocumentTreeReader reader = new DocumentTreeReader(session, root);
        NuxeoArchiveWriter writer = new NuxeoArchiveWriter(out);
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
        reader.close();
        writer.close();
    }

    @Override
    public void importSnapshot(CoreSession session, InputStream is) throws Exception {
        try {
            String importPath = this.persister.getDistributionRoot(session).getPathAsString();
            NuxeoArchiveReader reader = new NuxeoArchiveReader(is);
            DocumentModelWriter writer = new DocumentModelWriter(session, importPath);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while importing snapshot", (Throwable)e);
        }
    }

    @Override
    public void initSeamContext(HttpServletRequest request) {
        ((RuntimeSnapshot)this.getRuntimeSnapshot()).initSeamComponents(request);
    }

    @Override
    public void addPersistentSnapshot(String key, DistributionSnapshot snapshot) {
    }
}

