/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.comments;

import fr.toutatice.ecm.platform.automation.comments.AddComment;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;

@Operation(id="Document.CreateChildComment", category="Document", label="CreateChildCommentOfDocument", description="Add a child comment (answer) to a (commentable) document")
public class CreateChildComment {
    public static final String ID = "Document.CreateChildComment";
    @Context
    protected CoreSession session;
    @Param(name="commentableDoc", required=true)
    protected DocumentModel document;
    @Param(name="comment", required=true)
    protected DocumentModel comment;
    @Param(name="childComment", required=true)
    protected String childCommentContent;
    @Param(name="childCommentTitle", required=false)
    protected String childCommentTitle;
    @Param(name="fileName", required=false)
    protected String fileName;

    @OperationMethod
    public Object run() throws Exception {
        Boolean isModerated;
        boolean isPost = "Thread".equals(this.document.getType());
        CommentableDocument commentableDoc = (CommentableDocument)this.document.getAdapter(CommentableDocument.class);
        DocumentModel childComment = AddComment.createComment(this.document.getRef(), this.document.getType(), this.session, this.childCommentContent, this.childCommentTitle, this.fileName);
        DocumentModel commentDoc = commentableDoc.addComment(this.comment, childComment);
        if (isPost && !(isModerated = (Boolean)this.document.getProperty("thread", "moderated")).booleanValue()) {
            this.session.followTransition(commentDoc.getRef(), "moderation_publish");
        }
        return new StringBlob(commentDoc.getId());
    }
}

