/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jboss.seam.core.Events;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.TaskListFilter;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;

@Operation(id="Workflow.CreateProcess", category="Services", label="Create process", since="5.3.2", description="Enable to create a process bound to the document.")
public class StartWFProcess {
    public static final String ID = "Workflow.CreateProcess";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession coreSession;
    @Context
    protected transient JbpmService jbpmService;
    @Param(name="workflow type", required=true, order=0)
    protected String pd;
    @Param(name="task name", required=true, order=1)
    protected String td;
    @Param(name="following state", required=true, order=2)
    protected String endLifeCycle;
    @Param(name="actors", required=false, order=3)
    protected String keyForActors;
    @Param(name="due date", required=false, order=4)
    protected Date dueDate;
    @Param(name="directive", required=false, order=5)
    protected String directive;
    @Param(name="comment", required=false, order=6)
    protected String comment;
    @Param(name="right", required=true, order=7)
    protected String right;
    protected ProcessInstance currentProcess;
    protected ArrayList<VirtualTaskInstance> currentVirtualTasks;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        Principal principal = this.coreSession.getPrincipal();
        if (!(principal instanceof NuxeoPrincipal)) {
            throw new OperationException("Principal is not an instance of NuxeoPrincipal");
        }
        NuxeoPrincipal nuxpal = (NuxeoPrincipal)principal;
        HashMap<String, String> map = null;
        if (this.endLifeCycle != null && !this.endLifeCycle.equals("") && !"null".equals(this.endLifeCycle)) {
            map = new HashMap<String, String>();
            map.put(JbpmService.VariableName.endLifecycleTransition.name(), this.endLifeCycle);
        }
        this.jbpmService.createProcessInstance(nuxpal, this.pd, document, map, null);
        ProcessInstance pi = this.getCurrentProcess(document, nuxpal);
        ArrayList<Object> virtualTasks = this.getCurrentVirtualTasks(document, nuxpal);
        if (virtualTasks == null) {
            virtualTasks = new ArrayList();
        }
        ArrayList<String> prefixedActorIds = new ArrayList<String>();
        Object actors = this.ctx.get((Object)this.keyForActors);
        if (actors != null) {
            boolean throwError = false;
            try {
                if (actors instanceof List) {
                    prefixedActorIds.addAll((List)actors);
                } else if (actors instanceof String[]) {
                    for (String actor : (String[])actors) {
                        prefixedActorIds.add(actor);
                    }
                } else if (actors instanceof String) {
                    prefixedActorIds.add((String)actors);
                } else {
                    throwError = true;
                }
            }
            catch (ClassCastException e) {
                throwError = true;
            }
            if (throwError) {
                throw new OperationException(String.format("Invalid key to retrieve a list, array or single string of prefixed actor ids '%s', value is not correct: %s", this.keyForActors, actors));
            }
        }
        VirtualTaskInstance newVirtualTask = new VirtualTaskInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("right", this.right);
        newVirtualTask.setActors(prefixedActorIds);
        newVirtualTask.setDirective(this.directive);
        newVirtualTask.setDueDate(this.dueDate);
        newVirtualTask.setComment(this.comment);
        newVirtualTask.setParameters(parameters);
        virtualTasks.add(newVirtualTask);
        pi.getContextInstance().setVariable(JbpmService.VariableName.participants.name(), virtualTasks);
        this.jbpmService.persistProcessInstance(pi);
        TaskInstance startTask = this.getStartTask(document, nuxpal, this.td);
        if (startTask.hasEnded()) {
            throw new ClientException("Process is already started");
        }
        HashMap<String, ArrayList<Object>> transientVariables = new HashMap<String, ArrayList<Object>>();
        transientVariables.put(JbpmService.VariableName.participants.name(), this.getCurrentVirtualTasks(document, nuxpal));
        transientVariables.put(JbpmService.VariableName.document.name(), (ArrayList<Object>)document);
        transientVariables.put(JbpmService.VariableName.principal.name(), (ArrayList<Object>)nuxpal);
        this.jbpmService.endTask(Long.valueOf(startTask.getId()), null, null, null, transientVariables, nuxpal);
        this.coreSession.save();
        this.jbpmService.notifyEventListeners("workflowNewProcessStarted", "", new String[]{"user:" + nuxpal.getName()}, this.coreSession, nuxpal, document);
        Events.instance().raiseEvent("workflowNewProcessStarted", new Object[0]);
        return document;
    }

    protected TaskInstance getStartTask(DocumentModel document, NuxeoPrincipal principal, String taskName) throws ClientException {
        List tasks;
        ProcessInstance pi;
        TaskInstance startTask = null;
        if (taskName != null && (pi = this.getCurrentProcess(document, principal)) != null && (tasks = this.jbpmService.getTaskInstances(Long.valueOf(this.currentProcess.getId()), null, (JbpmListFilter)new TaskListFilter(new String[]{taskName}))) != null && !tasks.isEmpty()) {
            startTask = (TaskInstance)tasks.get(0);
        }
        if (startTask == null) {
            throw new ClientException("No start task found on current process with name " + taskName);
        }
        return startTask;
    }

    public ProcessInstance getCurrentProcess(DocumentModel document, NuxeoPrincipal principal) throws ClientException {
        List processes;
        if (this.currentProcess == null && (processes = this.jbpmService.getProcessInstances(document, principal, null)) != null && !processes.isEmpty()) {
            this.currentProcess = (ProcessInstance)processes.get(0);
        }
        return this.currentProcess;
    }

    public ArrayList<VirtualTaskInstance> getCurrentVirtualTasks(DocumentModel document, NuxeoPrincipal principal) throws ClientException {
        if (this.currentVirtualTasks == null) {
            Object participants;
            this.currentVirtualTasks = new ArrayList();
            ProcessInstance currentProcess = this.getCurrentProcess(document, principal);
            if (currentProcess != null && (participants = currentProcess.getContextInstance().getVariable(JbpmService.VariableName.participants.name())) != null && participants instanceof List) {
                this.currentVirtualTasks.addAll((List)participants);
            }
        }
        return this.currentVirtualTasks;
    }
}

