/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

@Operation(id="Document.GetUsersAndGroupsDocument", category="Services", label="Get users and groups document", since="5.4", description="List users and groups allowed to read the document.")
public class GetUsersAndGroupsDocument {
    public static final String ID = "Document.GetUsersAndGroupsDocument";
    private static final Log log = LogFactory.getLog(Log.class);

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        JSONArray rows = new JSONArray();
        ACP acp = doc.getACP();
        ACL[] aclTab = acp.getACLs();
        for (int i = 0; i < aclTab.length; ++i) {
            ACL acl = aclTab[i];
            ACE[] aceTab = acl.getACEs();
            for (int j = 0; j < aceTab.length; ++j) {
                ACE ace = aceTab[j];
                JSONObject obj = new JSONObject();
                if (!ace.isGranted()) continue;
                obj.element("userOrGroup", (Object)ace.getUsername());
                obj.element("permission", (Object)ace.getPermission());
                rows.add((Object)obj);
            }
        }
        if (rows.size() > 0) {
            return new StringBlob(rows.toString(), "application/json");
        }
        return null;
    }
}

