/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.utils.exception.ToutaticeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeOperationHelper {
    private static final Log log = LogFactory.getLog(ToutaticeOperationHelper.class);
    private static AutomationService automationService;

    private ToutaticeOperationHelper() {
    }

    public static void runOperationChain(CoreSession session, String chainId, Object document) throws ToutaticeException {
        OperationContext context = new OperationContext(session);
        context.setInput(document);
        ToutaticeOperationHelper.runOperationChain(session, chainId, context);
    }

    public static void runOperationChain(CoreSession session, String chainId, OperationContext context) throws ToutaticeException {
        try {
            AutomationService automationService = ToutaticeOperationHelper.getAutomationService();
            automationService.run(context, chainId);
        }
        catch (Exception e) {
            DocumentModel document = (DocumentModel)context.getInput();
            log.error((Object)("Failed to run the operation '" + chainId + "' on document '" + document.getName() + "', error: " + e.getMessage()));
            throw new ToutaticeException(e);
        }
    }

    private static AutomationService getAutomationService() throws ClientException {
        if (automationService == null) {
            try {
                automationService = (AutomationService)Framework.getService(AutomationService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to AutomationService. " + e.getMessage();
                log.error((Object)errMsg);
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (automationService == null) {
                String errMsg = "AutomationService service not bound";
                log.error((Object)errMsg);
                throw new ClientException(errMsg);
            }
        }
        return automationService;
    }
}

