/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.urlservice;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;
import org.nuxeo.runtime.api.Framework;

public class WebUrlCodec
extends AbstractDocumentViewCodec {
    private static final Log log = LogFactory.getLog(WebUrlCodec.class);
    private CoreSession documentManager;
    private static final String DEFAULT_REPO = "default";
    public static final String PREFIX = "nxurl";
    public static final String URL_PATTERN = "/([\\w\\.]+)/([\\w\\.]+)/([\\w\\.]+)@([\\w\\-\\.]+)/?(?:\\?(.*)?)?";
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]+)/([a-zA-Z_0-9\\-]+)+(\\?)?(.*)?";
    public static final String simpleURLPattern = "/([a-zA-Z_0-9\\-]+)+(\\?)?(.*)?";

    public WebUrlCodec() {
        try {
            Framework.login();
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repository = mgr.getDefaultRepository();
            if (repository != null) {
                this.documentManager = repository.open();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + simpleURLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            String webid = m.group(1);
            log.warn((Object)("webid : " + webid));
            DocumentModelList docs = null;
            try {
                docs = this.documentManager.query("SELECT * FROM Document where ttc:webid = '" + webid + "'");
            }
            catch (ClientException e) {
                log.error((Object)("Impossible de d\u00e9terminer la weburl " + (Object)((Object)e)));
            }
            if (docs.size() == 1 && docs.get(0) != null) {
                DocumentRef docRef = ((DocumentModel)docs.get(0)).getRef();
                String viewId = m.group(3);
                if (viewId.length() > 1) {
                    viewId = viewId.substring(1);
                }
                Map params = new HashMap();
                if (m.groupCount() > 3) {
                    String parameters = m.group(4);
                    params = URIUtils.getRequestParameters((String)parameters);
                }
                DocumentLocationImpl docLoc = new DocumentLocationImpl(DEFAULT_REPO, docRef);
                DocumentViewImpl documentViewImpl = new DocumentViewImpl((DocumentLocation)docLoc, viewId, params);
                log.warn((Object)"fin m\u00e9thode webid");
                return documentViewImpl;
            }
            log.error((Object)("More than one document with webid: " + webid));
        }
        return null;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        log.error((Object)"getUrlFromDocumentView non impl\u00e9ment\u00e9 ");
        return null;
    }
}

