/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.finder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.publisher.impl.finder.DefaultRootSectionsFinder;

public class ToutaticeRootSectionsFinder
extends DefaultRootSectionsFinder {
    private static final Log log = LogFactory.getLog(ToutaticeRootSectionsFinder.class);
    private static String CST_QUERY_LIST_PUBLISH_SPACES = "SELECT * FROM %s WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0";

    public ToutaticeRootSectionsFinder(CoreSession userSession) {
        super(userSession);
    }

    public void refreshRootSections() {
        if (this.unrestrictedDefaultSectionRoot != null) {
            this.unrestrictedDefaultSectionRoot.clear();
        }
    }

    protected DocumentModelList getDefaultSectionRoots(CoreSession session) throws ClientException {
        DocumentModelListImpl sectionRoots = new DocumentModelListImpl();
        for (String sectionRootType : this.getSectionRootTypes()) {
            DocumentModelList list = session.query(String.format(CST_QUERY_LIST_PUBLISH_SPACES, sectionRootType));
            UnrestrictedFilterSectionRootsRunner filter = new UnrestrictedFilterSectionRootsRunner(session, list, (DocumentModelList)sectionRoots);
            filter.runUnrestricted();
        }
        return sectionRoots;
    }

    private static class UnrestrictedFilterSectionRootsRunner
    extends UnrestrictedSessionRunner {
        DocumentModelList list;
        DocumentModelList sectionRoots;

        protected UnrestrictedFilterSectionRootsRunner(CoreSession session, DocumentModelList list, DocumentModelList sectionRoots) {
            super(session);
            this.list = list;
            this.sectionRoots = sectionRoots;
        }

        public void run() throws ClientException {
            for (DocumentModel sectionRoot : this.list) {
                try {
                    DocumentModel sectionRootParent = this.session.getParentDocument(sectionRoot.getRef());
                    if (sectionRootParent.hasFacet("MasterPublishSpace")) continue;
                    this.sectionRoots.add((Object)sectionRoot);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to filter the section roots, error: " + e.getMessage()));
                }
            }
        }
    }
}

