/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.document;

import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActions;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webapp.contentbrowser.OrderableDocumentActions;

@Name(value="orderableDocumentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeOrderableDocumentActions
extends OrderableDocumentActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeOrderableDocumentActions.class);
    public static final String QUERY_DOC_ORDERED_CHILDREN_QM = "SELECT * FROM Document WHERE ecm:parentId = '%s' AND ecm:isCheckedInVersion = 0 AND ecm:mixinType != 'HiddenInNavigation' AND ecm:currentLifeCycleState != 'deleted' AND (ecm:name NOT LIKE '%%.proxy') ORDER BY ecm:pos";
    public static final int CST_MAX_RESULT_SET_SIZE = 10000;
    @In(create=true, required=false)
    protected transient ToutaticeDocumentActions documentActions;

    protected boolean getCanMoveDown(DocumentModel container, String documentsListName) throws ClientException {
        boolean status = false;
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (null != docs && docs.size() == 1) {
            status = true;
            DocumentModel selectedDocument = (DocumentModel)docs.get(0);
            DocumentModelList children = this.getChildrenFor(container.getId());
            int selectedDocumentIndex = children.indexOf(selectedDocument);
            int nextIndex = selectedDocumentIndex + 1;
            if (nextIndex == children.size()) {
                status = false;
            }
            if (status) {
                status = this.checkPermissions(container, selectedDocument, (DocumentModel)children.get(nextIndex));
            }
        }
        return status;
    }

    protected boolean getCanMoveUp(DocumentModel container, String documentsListName) throws ClientException {
        boolean status = false;
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (null != docs && docs.size() == 1) {
            status = true;
            DocumentModel selectedDocument = (DocumentModel)docs.get(0);
            DocumentModelList children = this.getChildrenFor(container.getId());
            int selectedDocumentIndex = children.indexOf(selectedDocument);
            int previousIndex = selectedDocumentIndex - 1;
            if (previousIndex < 0) {
                status = false;
            }
            if (status) {
                status = this.checkPermissions(container, selectedDocument, (DocumentModel)children.get(previousIndex));
            }
        }
        return status;
    }

    protected boolean getCanMoveToTop(DocumentModel container, String documentsListName) throws ClientException {
        boolean status = false;
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (null != docs && docs.size() == 1) {
            status = true;
            DocumentModel selectedDocument = (DocumentModel)docs.get(0);
            DocumentModelList children = this.getChildrenFor(container.getId());
            int selectedDocumentIndex = children.indexOf(selectedDocument);
            if (selectedDocumentIndex <= 0) {
                status = false;
            }
            if (status) {
                status = this.checkPermissions(container, selectedDocument, null);
            }
        }
        return status;
    }

    protected boolean getCanMoveToBottom(DocumentModel container, String documentsListName) throws ClientException {
        boolean status = false;
        List docs = this.documentsListsManager.getWorkingList(documentsListName);
        if (null != docs && docs.size() == 1) {
            status = true;
            DocumentModel selectedDocument = (DocumentModel)docs.get(0);
            DocumentModelList children = this.getChildrenFor(container.getId());
            int selectedDocumentIndex = children.indexOf(selectedDocument);
            if (selectedDocumentIndex >= children.size() - 1) {
                status = false;
            }
            if (status) {
                status = this.checkPermissions(container, selectedDocument, null);
            }
        }
        return status;
    }

    protected String moveDown(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        DocumentModelList children = this.getChildrenFor(container.getId());
        int selectedDocumentIndex = children.indexOf(selectedDocument);
        int nextIndex = selectedDocumentIndex + 1;
        DocumentModel nextDocument = (DocumentModel)children.get(nextIndex);
        this.documentManager.orderBefore(container.getRef(), nextDocument.getName(), selectedDocument.getName());
        this.moveDocumentProxy(container, selectedDocument);
        this.moveDocumentProxy(container, nextDocument);
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedDown");
        return null;
    }

    protected String moveUp(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        DocumentModelList children = this.getChildrenFor(container.getId());
        int selectedDocumentIndex = children.indexOf(selectedDocument);
        int previousIndex = selectedDocumentIndex - 1;
        DocumentModel previousDocument = (DocumentModel)children.get(previousIndex);
        this.documentManager.orderBefore(container.getRef(), selectedDocument.getName(), previousDocument.getName());
        this.moveDocumentProxy(container, selectedDocument);
        this.moveDocumentProxy(container, previousDocument);
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedUp");
        return null;
    }

    protected String moveToTop(DocumentModel container, String documentsListName) throws ClientException {
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        DocumentModelList children = this.getChildrenFor(container.getId());
        DocumentModel firstDocument = (DocumentModel)children.get(0);
        this.documentManager.orderBefore(container.getRef(), selectedDocument.getName(), firstDocument.getName());
        this.moveDocumentProxy(container, selectedDocument);
        this.moveDocumentProxy(container, firstDocument);
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedToTop");
        return null;
    }

    protected String moveToBottom(DocumentModel container, String documentsListName) throws ClientException {
        DocumentRef containerRef = container.getRef();
        DocumentModel selectedDocument = (DocumentModel)this.documentsListsManager.getWorkingList(documentsListName).get(0);
        this.documentManager.orderBefore(containerRef, selectedDocument.getName(), null);
        this.moveDocumentProxy(container, selectedDocument);
        this.documentManager.save();
        this.notifyChildrenChanged(container);
        this.addFacesMessage("feedback.order.movedToBottom");
        return null;
    }

    protected DocumentModelList getChildrenFor(String containerId) throws ClientException {
        try {
            return this.documentManager.query(String.format(QUERY_DOC_ORDERED_CHILDREN_QM, containerId), 10000);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    private void moveDocumentProxy(DocumentModel container, DocumentModel document) throws ClientException {
        DocumentModel proxy = this.documentActions.getProxy(document);
        if (null != proxy) {
            this.documentManager.orderBefore(container.getRef(), proxy.getName(), document.getName());
        }
    }

    private boolean checkPermissions(DocumentModel container, DocumentModel source, DocumentModel destination) throws ClientException {
        boolean status = true;
        if (!this.documentManager.hasPermission(container.getRef(), "Write") || !this.documentManager.hasPermission(source.getRef(), "Write") || null != destination && !this.documentManager.hasPermission(destination.getRef(), "Write")) {
            status = false;
        }
        return status;
    }
}

