/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.types.GenericLayoutDescriptor;
import org.nuxeo.ecm.platform.types.GenericLayoutsDescriptor;
import org.nuxeo.ecm.platform.types.GenericUIService;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.PositionLayoutDescriptor;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class GenericUIServiceImpl
extends DefaultComponent
implements GenericUIService {
    private static final long serialVersionUID = -3335398967270359400L;
    private static final Log log = LogFactory.getLog(GenericUIServiceImpl.class);
    private static final String LAYOUTS_PT_EXT = "layouts";
    private static final String BASE_TYPE = "Document";
    private static final String ALL_TYPES = "*";
    private TypeManager typeManager;
    private List<GenericLayoutsDescriptor> allGenericLayoutsDescriptor = new ArrayList<GenericLayoutsDescriptor>();

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.typeManager = (TypeManager)Framework.getService(TypeManager.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (LAYOUTS_PT_EXT.equals(extensionPoint)) {
            GenericLayoutsDescriptor genericLayoutsDescriptor = (GenericLayoutsDescriptor)contribution;
            this.allGenericLayoutsDescriptor.add(genericLayoutsDescriptor);
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        Map<String, List<GenericLayoutsDescriptor>> sortedContribs = this.sortContribs(this.allGenericLayoutsDescriptor);
        if (sortedContribs != null) {
            for (List<GenericLayoutsDescriptor> contribsByMode : sortedContribs.values()) {
                GenericLayoutsDescriptor mergedContribs = this.mergeContribs(contribsByMode);
                this.addGenericUIElements(mergedContribs);
            }
        }
    }

    private Map<String, List<GenericLayoutsDescriptor>> sortContribs(List<GenericLayoutsDescriptor> allContribs) {
        HashMap<String, List<GenericLayoutsDescriptor>> sortedContribs = new HashMap<String, List<GenericLayoutsDescriptor>>();
        if (allContribs != null) {
            for (Mode modeType : Mode.values()) {
                String mode = modeType.value();
                for (GenericLayoutsDescriptor contrib : allContribs) {
                    String contribMode = contrib.getMode();
                    if (!mode.equals(contribMode)) continue;
                    ArrayList<GenericLayoutsDescriptor> contribsOfMode = (ArrayList<GenericLayoutsDescriptor>)sortedContribs.get(mode);
                    if (sortedContribs.containsKey(mode)) {
                        contribsOfMode.add(contrib);
                        continue;
                    }
                    if (contribsOfMode == null) {
                        contribsOfMode = new ArrayList<GenericLayoutsDescriptor>();
                    }
                    contribsOfMode.add(contrib);
                    sortedContribs.put(mode, contribsOfMode);
                }
            }
        }
        return sortedContribs;
    }

    private GenericLayoutsDescriptor mergeContribs(List<GenericLayoutsDescriptor> contribsByMode) {
        GenericLayoutsDescriptor mergedContrib = new GenericLayoutsDescriptor();
        if (contribsByMode != null) {
            HashMap<String, GenericLayoutDescriptor> mergedLayouts = new HashMap<String, GenericLayoutDescriptor>();
            String mode = "";
            for (GenericLayoutsDescriptor contrib : contribsByMode) {
                mode = contrib.getMode();
                GenericLayoutDescriptor[] layouts = contrib.getLayoutsToInsert();
                if (layouts == null) continue;
                for (GenericLayoutDescriptor layout : layouts) {
                    String layoutName = layout.getName();
                    if (!mergedLayouts.containsKey(layoutName)) {
                        mergedLayouts.put(layoutName, layout);
                        continue;
                    }
                    GenericLayoutDescriptor storedLayout = (GenericLayoutDescriptor)mergedLayouts.get(layoutName);
                    PositionLayoutDescriptor position = layout.getPositionLayoutDescriptor();
                    if (position != null) {
                        storedLayout.positionDescriptor = position;
                    }
                    Object[] excludedTypes = layout.getExcludedTypes();
                    Object[] storedExcludedTypes = storedLayout.getExcludedTypes();
                    if (excludedTypes != null && storedExcludedTypes != null) {
                        storedLayout.excludedTypes = (String[])ArrayUtils.addAll((Object[])excludedTypes, (Object[])storedExcludedTypes);
                    }
                    mergedLayouts.put(layoutName, storedLayout);
                }
            }
            mergedContrib.mode = mode;
            Collection finalMergedLayouts = mergedLayouts.values();
            mergedContrib.layouts = finalMergedLayouts != null ? finalMergedLayouts.toArray(new GenericLayoutDescriptor[0]) : new GenericLayoutDescriptor[0];
        }
        return mergedContrib;
    }

    @Override
    public void addGenericUIElements(GenericLayoutsDescriptor genericLayoutsDescriptor) throws Exception {
        GenericLayoutDescriptor[] genericLayouts = genericLayoutsDescriptor.getLayoutsToInsert();
        if (genericLayouts != null && genericLayouts.length > 0) {
            Collection types = this.typeManager.getTypes();
            for (Type type : types) {
                String docType = type.getId();
                if (BASE_TYPE.equals(docType)) continue;
                HashMap<String, Layouts> finalLayoutsMap = new HashMap<String, Layouts>(0);
                Layouts finalLayouts = new Layouts();
                Map layoutsOfTypeMap = type.getLayouts();
                finalLayoutsMap.putAll(layoutsOfTypeMap);
                String mode = genericLayoutsDescriptor.getMode();
                Layouts layoutsByModeAndType = (Layouts)layoutsOfTypeMap.get(mode);
                if (layoutsByModeAndType == null) continue;
                String[] layoutsNames = layoutsByModeAndType.getLayouts();
                ArrayList<String> allLayoutsNames = new ArrayList<String>(Arrays.asList(layoutsNames));
                for (GenericLayoutDescriptor genericLayout : genericLayouts) {
                    String genericLayoutName = genericLayout.getName();
                    Object[] contribExcludedTypes = genericLayout.getExcludedTypes();
                    boolean allTypesExcluded = false;
                    if (contribExcludedTypes != null && contribExcludedTypes.length > 0) {
                        allTypesExcluded = ((String)contribExcludedTypes[0]).equals(ALL_TYPES);
                    }
                    Object[] excludedTypes = (String[])ArrayUtils.addAll((Object[])new String[1], (Object[])contribExcludedTypes);
                    if (allTypesExcluded || ArrayUtils.contains((Object[])excludedTypes, (Object)docType)) continue;
                    PositionLayoutDescriptor positionLayout = genericLayout.getPositionLayoutDescriptor();
                    if (positionLayout != null) {
                        String beforeLayout = positionLayout.getBeforeLayout();
                        String afterLayout = positionLayout.getAfterLayout();
                        String atLayout = positionLayout.getPositionLayout();
                        if (beforeLayout != null) {
                            this.placeLayout(allLayoutsNames, genericLayoutName, beforeLayout, false);
                            continue;
                        }
                        if (afterLayout != null) {
                            this.placeLayout(allLayoutsNames, genericLayoutName, afterLayout, true);
                            continue;
                        }
                        if (!atLayout.equals("end")) {
                            int atPos = Integer.valueOf(atLayout);
                            if (atPos != -999) {
                                allLayoutsNames.add(atPos - 1, genericLayoutName);
                                continue;
                            }
                            log.error((Object)("No defined position for generic layout " + genericLayoutName));
                            continue;
                        }
                        allLayoutsNames.add(allLayoutsNames.size(), genericLayoutName);
                        continue;
                    }
                    log.error((Object)("No defined position for generic layout " + genericLayoutName));
                }
                finalLayouts.layouts = allLayoutsNames.toArray(new String[allLayoutsNames.size()]);
                finalLayoutsMap.put(mode, finalLayouts);
                type.setLayouts(finalLayoutsMap);
            }
        }
    }

    private void placeLayout(List<String> allLayoutsNames, String genericLayoutName, String layout, boolean after) throws Exception {
        int layoutPos = this.findLayoutPosition(allLayoutsNames, layout);
        if (layoutPos != -999) {
            if (after) {
                allLayoutsNames.add(layoutPos + 1, genericLayoutName);
            } else {
                allLayoutsNames.add(layoutPos, genericLayoutName);
            }
        } else {
            allLayoutsNames.add(allLayoutsNames.size(), genericLayoutName);
        }
    }

    private int findLayoutPosition(List<String> allLayoutsNames, String layout) {
        int position = -999;
        boolean found = false;
        for (int index = 0; index < allLayoutsNames.size() && !found; ++index) {
            String currentLayout = allLayoutsNames.get(index);
            if (!currentLayout.equals(layout)) continue;
            found = true;
            position = index;
        }
        return position;
    }

    private static enum Mode {
        VIEW("view"),
        EDIT("edit"),
        CREATE("create");

        private String value;

        private Mode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

