/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.onlyoffice.conversion;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;

public class ConversionCompatibility {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="input")
    private List<String> input;
    @JsonProperty(value="output")
    private List<String> output;
    @JsonProperty(value="disallowed")
    private Set<String> disallowed;

    public String getName() {
        return this.name;
    }

    public List<String> getInput() {
        return this.input;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public Set<String> getDisallowed() {
        return this.disallowed;
    }

    public boolean accepts(String inputType, String outputType) {
        return this.input.contains(inputType) && this.output.contains(outputType) && !this.disallowed.contains(String.format("%s-%s", inputType, outputType));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.disallowed == null ? 0 : this.disallowed.hashCode());
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConversionCompatibility other = (ConversionCompatibility)obj;
        if (this.disallowed == null ? other.disallowed != null : !this.disallowed.equals(other.disallowed)) {
            return false;
        }
        if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.output == null ? other.output != null : !this.output.equals(other.output));
    }

    public String toString() {
        return String.format("ConversionCompatibility [name=%s, input=%s, output=%s, disallowed=%s]", this.name, this.input, this.output, this.disallowed);
    }
}

