/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.Helpers;
import org.nuxeo.wopi.Operation;
import org.nuxeo.wopi.exception.BadRequestException;
import org.nuxeo.wopi.exception.ConflictException;
import org.nuxeo.wopi.exception.NotImplementedException;
import org.nuxeo.wopi.exception.PreConditionFailedException;
import org.nuxeo.wopi.lock.LockHelper;

@WebObject(type="wopiFiles")
public class FilesEndpoint
extends DefaultObject {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    @Context
    protected HttpHeaders httpHeaders;
    protected CoreSession session;
    protected DocumentModel doc;
    protected Blob blob;
    protected String xpath;
    protected String fileId;

    public void initialize(Object ... args) {
        assert (args != null && args.length == 4);
        this.session = (CoreSession)args[0];
        this.doc = (DocumentModel)args[1];
        this.blob = (Blob)args[2];
        this.xpath = (String)args[3];
        this.fileId = FileInfo.computeFileId(this.doc, this.xpath);
    }

    @GET
    @Produces(value={"application/json"})
    public Object checkFileInfo() {
        return this.buildCheckFileInfoMap();
    }

    @GET
    @Path(value="contents")
    public Object getFile(@HeaderParam(value="X-WOPI-MaxExpectedSize") String maxExpectedSizeHeader) {
        int maxExpectedSize = this.getMaxExpectedSize(maxExpectedSizeHeader);
        if (this.blob.getLength() > (long)maxExpectedSize) {
            throw new PreConditionFailedException();
        }
        this.response.addHeader("X-WOPI-ItemVersion", this.doc.getVersionLabel());
        return this.blob;
    }

    @POST
    public Object doPost(@HeaderParam(value="X-WOPI-Override") Operation operation) {
        switch (operation) {
            case DELETE: {
                return this.deleteFile();
            }
            case GET_LOCK: {
                return this.getLock();
            }
            case GET_SHARE_URL: {
                return this.getShareUrl();
            }
            case LOCK: {
                return this.lock();
            }
            case PUT_RELATIVE: {
                return this.putRelativeFile();
            }
            case REFRESH_LOCK: {
                return this.refreshLock();
            }
            case RENAME_FILE: {
                return this.renameFile();
            }
            case UNLOCK: {
                return this.unlock();
            }
        }
        throw new BadRequestException();
    }

    protected Object lock() {
        String lock = this.getHeader("X-WOPI-Lock");
        String oldLock = this.getHeader("X-WOPI-OldLock", true);
        boolean isLocked = this.doc.isLocked();
        if (!isLocked) {
            if (!StringUtils.isEmpty((CharSequence)oldLock)) {
                this.response.addHeader("X-WOPI-Lock", "");
                throw new ConflictException();
            }
            this.checkWritePropertiesPermission();
            this.doc.setLock();
            LockHelper.addLock(this.fileId, lock);
            this.response.addHeader("X-WOPI-ItemVersion", this.doc.getVersionLabel());
            return Response.ok().build();
        }
        String currentLock = this.getCurrentLock();
        if (StringUtils.isEmpty((CharSequence)oldLock)) {
            if (lock.equals(currentLock)) {
                LockHelper.refreshLock(this.fileId);
                this.response.addHeader("X-WOPI-ItemVersion", this.doc.getVersionLabel());
                return Response.ok().build();
            }
        } else if (oldLock.equals(currentLock)) {
            LockHelper.updateLock(this.fileId, lock);
            return Response.ok().build();
        }
        return this.buildConflictResponse(currentLock);
    }

    protected String getCurrentLock() {
        String currentLock = LockHelper.getLock(this.fileId);
        if (currentLock == null) {
            throw new ConflictException();
        }
        return currentLock;
    }

    protected Response buildConflictResponse(String currentLock) {
        this.response.addHeader("X-WOPI-Lock", currentLock);
        return Response.status((Response.Status)Response.Status.CONFLICT).build();
    }

    protected Object getLock() {
        if (!this.doc.isLocked()) {
            this.response.addHeader("X-WOPI-Lock", "");
            return Response.ok().build();
        }
        String currentLock = this.getCurrentLock();
        this.response.addHeader("X-WOPI-Lock", currentLock);
        return Response.ok().build();
    }

    protected Object unlockOrRefresh(String lock, boolean unlock) {
        boolean isLocked = this.doc.isLocked();
        if (!isLocked) {
            this.response.addHeader("X-WOPI-Lock", "");
            throw new ConflictException();
        }
        String currentLock = this.getCurrentLock();
        if (lock.equals(currentLock)) {
            this.checkWritePropertiesPermission();
            if (unlock) {
                this.doc.removeLock();
                LockHelper.removeLock(this.fileId);
                this.response.addHeader("X-WOPI-ItemVersion", this.doc.getVersionLabel());
            } else {
                LockHelper.refreshLock(this.fileId);
            }
            return Response.ok().build();
        }
        return this.buildConflictResponse(currentLock);
    }

    public Object putRelativeFile() {
        String relativeTarget;
        String suggestedTarget = this.getHeader("X-WOPI-SuggestedTarget", true);
        if (suggestedTarget != null) {
            suggestedTarget = Helpers.readUTF7String(suggestedTarget);
        }
        if ((relativeTarget = this.getHeader("X-WOPI-RelativeTarget", true)) != null) {
            relativeTarget = Helpers.readUTF7String(relativeTarget);
        }
        if (StringUtils.isEmpty((CharSequence)suggestedTarget) == StringUtils.isEmpty((CharSequence)relativeTarget)) {
            throw new NotImplementedException();
        }
        DocumentRef parentRef = this.doc.getParentRef();
        if (!this.session.exists(parentRef) || !this.session.hasPermission(parentRef, "AddChildren")) {
            throw new NotImplementedException();
        }
        String newFileName = relativeTarget;
        if (StringUtils.isNotEmpty((CharSequence)suggestedTarget)) {
            newFileName = suggestedTarget.startsWith(".") ? FilenameUtils.getBaseName((String)this.blob.getFilename()) + suggestedTarget : suggestedTarget;
        }
        DocumentModel parent = this.session.getDocument(parentRef);
        DocumentModel newDoc = this.session.createDocumentModel(parent.getPathAsString(), newFileName, this.doc.getType());
        newDoc.copyContent(this.doc);
        newDoc.setPropertyValue("dc:title", (Serializable)((Object)newFileName));
        Blob newBlob = this.createBlobFromRequestBody(newFileName, null);
        newDoc.setPropertyValue("file:content", (Serializable)newBlob);
        newDoc = this.session.createDocument(newDoc);
        String token = Helpers.createJWTToken();
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)this.request);
        String newFileId = FileInfo.computeFileId(newDoc, "file:content");
        String wopiSrc = String.format("%ssite/wopi/files/%s?access_token=%s", baseURL, newFileId, token);
        String hostViewUrl = String.format("%swopi/%s/default/%s", baseURL, "view", newDoc.getId());
        String hostEditUrl = String.format("%swopi/%s/default/%s", baseURL, "edit", newDoc.getId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", newFileName);
        map.put("Url", wopiSrc);
        map.put("HostViewUrl", hostViewUrl);
        map.put("HostEditUrl", hostEditUrl);
        return Response.ok(map).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Produces(value={"application/json"})
    public Object renameFile() {
        this.checkWritePropertiesPermission();
        String requestedName = Helpers.readUTF7String(this.getHeader("X-WOPI-RequestedName"));
        if (!this.doc.isLocked()) {
            return this.renameBlob(requestedName);
        }
        String currentLock = this.getCurrentLock();
        String lock = this.getHeader("X-WOPI-Lock");
        if (lock.equals(currentLock)) {
            return this.renameBlob(requestedName);
        }
        return this.buildConflictResponse(currentLock);
    }

    protected Response renameBlob(String requestedName) {
        String extension = FilenameUtils.getExtension((String)this.blob.getFilename());
        String fullFilename = requestedName + (extension != null ? "." + extension : "");
        this.blob.setFilename(fullFilename);
        this.doc.setPropertyValue("file:content", (Serializable)this.blob);
        this.doc.putContextData("source", (Serializable)((Object)"wopi"));
        this.session.saveDocument(this.doc);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", requestedName);
        return Response.ok(map).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Object deleteFile() {
        if (this.doc.isLocked()) {
            String currentLock = this.getCurrentLock();
            return this.buildConflictResponse(currentLock);
        }
        if (!this.session.hasPermission(this.doc.getRef(), "Remove")) {
            throw new ConflictException();
        }
        this.session.removeDocument(this.doc.getRef());
        return Response.ok().build();
    }

    @Produces(value={"application/json"})
    public Object getShareUrl() {
        String urlType = this.getHeader("X-WOPI-UrlType", true);
        if (!"ReadOnly".equals(urlType) && !"ReadWrite".equals(urlType)) {
            throw new NotImplementedException();
        }
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)this.request);
        String shareURL = String.format("%swopi/%s/%s/%s/%s", baseURL, urlType.equals("ReadOnly") ? "view" : "edit", this.doc.getRepositoryName(), this.doc.getId(), this.xpath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ShareUrl", shareURL);
        return Response.ok(map).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="contents")
    public Object doPostContents(@HeaderParam(value="X-WOPI-Override") Operation operation) {
        if (Operation.PUT.equals((Object)operation)) {
            return this.putFile();
        }
        throw new BadRequestException();
    }

    public Object putFile() {
        this.checkWritePropertiesPermission();
        if (!this.doc.isLocked()) {
            if (this.blob.getLength() == 0L) {
                return this.updateBlob();
            }
            this.response.addHeader("X-WOPI-Lock", "");
            throw new ConflictException();
        }
        String currentLock = this.getCurrentLock();
        String lock = this.getHeader("X-WOPI-Lock");
        if (lock.equals(currentLock)) {
            return this.updateBlob();
        }
        return this.buildConflictResponse(currentLock);
    }

    protected Response updateBlob() {
        Blob newBlob = this.createBlobFromRequestBody(this.blob.getFilename(), this.blob.getMimeType());
        this.doc.setPropertyValue("file:content", (Serializable)newBlob);
        this.doc.putContextData("source", (Serializable)((Object)"wopi"));
        this.doc = this.session.saveDocument(this.doc);
        this.response.addHeader("X-WOPI-ItemVersion", this.doc.getVersionLabel());
        return Response.ok().build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Blob createBlobFromRequestBody(String filename, String mimeType) {
        try (ServletInputStream is = this.request.getInputStream();){
            Blob newBlob = Blobs.createBlob((InputStream)is);
            newBlob.setFilename(filename);
            newBlob.setMimeType(mimeType);
            Blob blob = newBlob;
            return blob;
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Object unlock() {
        String lock = this.getHeader("X-WOPI-Lock");
        return this.unlockOrRefresh(lock, true);
    }

    protected Object refreshLock() {
        String lock = this.getHeader("X-WOPI-Lock");
        return this.unlockOrRefresh(lock, false);
    }

    protected int getMaxExpectedSize(String maxExpectedSizeHeader) {
        if (!StringUtils.isEmpty((CharSequence)maxExpectedSizeHeader)) {
            try {
                return Integer.parseInt(maxExpectedSizeHeader, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    protected String getHeader(String headerName) {
        return this.getHeader(headerName, false);
    }

    protected String getHeader(String headerName, boolean nullable) {
        String header;
        List headers = this.httpHeaders.getRequestHeader(headerName);
        String string = header = headers == null || headers.isEmpty() ? null : (String)headers.get(0);
        if (StringUtils.isEmpty(header) && !nullable) {
            throw new BadRequestException();
        }
        return header;
    }

    protected void checkWritePropertiesPermission() {
        if (!this.session.hasPermission(this.doc.getRef(), "WriteProperties")) {
            throw new ConflictException();
        }
    }

    protected Map<String, Serializable> buildCheckFileInfoMap() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.session.getPrincipal();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        FilesEndpoint.addRequiredProperties(map, this.doc, this.blob, principal);
        FilesEndpoint.addHostCapabilitiesProperties(map);
        FilesEndpoint.addUserMetadataProperties(map, principal);
        FilesEndpoint.addUserPermissionsProperties(map, this.session, this.doc);
        FilesEndpoint.addFileURLProperties(map);
        FilesEndpoint.addBreadcrumbProperties(map, this.session, this.doc, VirtualHostHelper.getBaseURL((ServletRequest)this.request));
        return map;
    }

    protected static void addRequiredProperties(Map<String, Serializable> map, DocumentModel doc, Blob blob, NuxeoPrincipal principal) {
        map.put("BaseFileName", (Serializable)((Object)blob.getFilename()));
        map.put("OwnerId", doc.getPropertyValue("dc:creator"));
        map.put("Size", Long.valueOf(blob.getLength()));
        map.put("UserId", (Serializable)((Object)principal.getName()));
        map.put("Version", (Serializable)((Object)doc.getVersionLabel()));
    }

    protected static void addHostCapabilitiesProperties(Map<String, Serializable> map) {
        map.put("SupportsExtendedLockLength", Boolean.valueOf(true));
        map.put("SupportsLocks", Boolean.valueOf(true));
        map.put("SupportsRename", Boolean.valueOf(true));
        map.put("SupportsUpdate", Boolean.valueOf(true));
        map.put("SupportsDeleteFile", Boolean.valueOf(true));
        map.put("SupportedShareUrlTypes", (Serializable)new String[]{"ReadOnly", "ReadWrite"});
    }

    protected static void addUserMetadataProperties(Map<String, Serializable> map, NuxeoPrincipal principal) {
        map.put("IsAnonymousUser", Boolean.valueOf(principal.isAnonymous()));
        map.put("UserFriendlyName", (Serializable)((Object)Helpers.principalFullName(principal)));
    }

    protected static void addUserPermissionsProperties(Map<String, Serializable> map, CoreSession session, DocumentModel doc) {
        boolean hasAddChildren = session.exists(doc.getParentRef()) && session.hasPermission(doc.getParentRef(), "AddChildren");
        boolean hasWriteProperties = session.hasPermission(doc.getRef(), "WriteProperties");
        map.put("ReadOnly", Boolean.valueOf(!hasWriteProperties));
        map.put("UserCanRename", Boolean.valueOf(hasWriteProperties));
        map.put("UserCanWrite", Boolean.valueOf(hasWriteProperties));
        map.put("UserCanNotWriteRelative", Boolean.valueOf(!hasAddChildren));
    }

    protected static void addFileURLProperties(Map<String, Serializable> map) {
    }

    protected static void addBreadcrumbProperties(Map<String, Serializable> map, CoreSession session, DocumentModel doc, String baseURL) {
        map.put("BreadcrumbBrandName", (Serializable)((Object)Framework.getProperty((String)"org.nuxeo.ecm.product.name")));
        map.put("BreadcrumbBrandUrl", (Serializable)((Object)baseURL));
        DocumentRef parentRef = doc.getParentRef();
        if (session.exists(parentRef)) {
            DocumentModel parent = session.getDocument(parentRef);
            map.put("BreadcrumbFolderName", (Serializable)((Object)parent.getTitle()));
            String url = FilesEndpoint.getDocumentURL(parent, baseURL);
            if (url != null) {
                map.put("BreadcrumbFolderUrl", (Serializable)((Object)url));
            }
        }
    }

    protected static String getDocumentURL(DocumentModel doc, String baseURL) {
        TypeInfo adapter = (TypeInfo)doc.getAdapter(TypeInfo.class);
        if (adapter != null) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, adapter.getDefaultView());
            return ((DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class)).getUrlFromDocumentView("notificationDocId", (DocumentView)docView, true, baseURL);
        }
        return null;
    }
}

