/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.wopi.FileInfo;
import org.nuxeo.wopi.Helpers;

public class WOPIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String WORD_VIEW_URL = "https://word-view.officeapps-df.live.com/wv/wordviewerframe.aspx?";
    public static final String WORD_EDIT_URL = "https://word-edit.officeapps-df.live.com/we/wordeditorframe.aspx?";
    public static final String EXCEL_VIEW_URL = "https://excel.officeapps-df.live.com/x/_layouts/xlviewerinternal.aspx?";
    public static final String EXCEL_EDIT_URL = "https://excel.officeapps-df.live.com/x/_layouts/xlviewerinternal.aspx?edit=1&";
    public static final String POWERPOINT_VIEW_URL = "https://powerpoint.officeapps-df.live.com/p/PowerPointFrame.aspx?PowerPointView=ReadingView&";
    public static final String POWERPOINT_EDIT_URL = "https://powerpoint.officeapps-df.live.com/p/PowerPointFrame.aspx?PowerPointView=EditView&";
    public static final String WOPITEST_VIEW_URL = "https://onenote.officeapps-df.live.com/hosting/WopiTestFrame.aspx?";
    public static final Map<Pair<String, String>, Pair<String, String>> ACTIONS_TO_URLS = new HashMap<Pair<String, String>, Pair<String, String>>();
    public static final String WOPI_JSP = "/wopi.jsp";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path == null) {
            response.sendError(400, "Invalid path: " + path);
            return;
        }
        String[] parts = (path = path.substring(1, path.length())).split("/");
        int length = parts.length;
        if (length < 3) {
            response.sendError(400, "Invalid path: " + path);
            return;
        }
        String action = parts[0];
        String repository = parts[1];
        String docId = parts[2];
        String xpath = parts.length == 4 ? parts[3] : "file:content";
        try (CloseableCoreSession session = CoreInstance.openCoreSession((String)repository);){
            IdRef ref = new IdRef(docId);
            if (!session.exists((DocumentRef)ref)) {
                response.sendError(404, "Document not found");
                return;
            }
            DocumentModel doc = session.getDocument((DocumentRef)ref);
            Blob blob = this.getBlob(doc, xpath);
            if (blob == null) {
                response.sendError(404, "No blob on document");
                return;
            }
            String extension = FilenameUtils.getExtension((String)blob.getFilename());
            Pair<String, String> pair = ACTIONS_TO_URLS.get(Pair.of((Object)action, (Object)extension));
            String url = (String)pair.getRight();
            if (url == null) {
                response.sendError(404, "Cannot open file with Office Online");
                return;
            }
            String token = Helpers.createJWTToken();
            request.setAttribute("accessToken", (Object)token);
            request.setAttribute("accessTokenTTL", (Object)Helpers.getJWTTokenExp(token));
            String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)request);
            String fileId = FileInfo.computeFileId(doc, xpath);
            String wopiSrc = URLEncoder.encode(String.format("%ssite/wopi/files/%s", baseURL, fileId), StandardCharsets.UTF_8.name());
            request.setAttribute("formURL", (Object)(url + "WOPISrc" + "=" + wopiSrc));
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(WOPI_JSP);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected Blob getBlob(DocumentModel doc, String xpath) {
        return (Blob)doc.getPropertyValue(xpath);
    }

    static {
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"doc"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"docm"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"docx"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"dot"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"dotm"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"docx"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"odt"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"rtf"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"docm"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"docx"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"odt"), (Pair<String, String>)Pair.of((Object)"Word", (Object)WORD_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"csv"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"ods"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"xls"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"xlsb"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"xlsm"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"xlsx"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"ods"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"xlsb"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"xlsm"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"xlsx"), (Pair<String, String>)Pair.of((Object)"Excel", (Object)EXCEL_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"odp"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"pot"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"potm"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"potx"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"pps"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"ppsm"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"ppsx"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"ppt"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"pptm"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"pptx"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_VIEW_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"odp"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"ppsx"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"edit", (Object)"pptx"), (Pair<String, String>)Pair.of((Object)"PowerPoint", (Object)POWERPOINT_EDIT_URL));
        ACTIONS_TO_URLS.put((Pair<String, String>)Pair.of((Object)"view", (Object)"wopitest"), (Pair<String, String>)Pair.of((Object)"WopiTest", (Object)WOPITEST_VIEW_URL));
    }
}

