/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wopi;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.wopi.WOPIServlet;
import org.nuxeo.wopi.lock.LockHelper;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WOPIJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "wopi";
    public static final String APP_NAME_FIELD = "appName";
    public static final String LOCKED_FIELD = "locked";

    public WOPIJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        if (!document.hasSchema("file")) {
            return;
        }
        Blob blob = (Blob)document.getPropertyValue("file:content");
        if (blob == null) {
            return;
        }
        String viewURL = null;
        String editURL = null;
        String extension = FilenameUtils.getExtension((String)blob.getFilename());
        if (this.isExtensionSupported(extension, "view")) {
            viewURL = this.getWOPIURL(document, "view");
        }
        if (this.isExtensionSupported(extension, "edit")) {
            try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
                if (wrapper.getSession().hasPermission(document.getRef(), "WriteProperties")) {
                    editURL = this.getWOPIURL(document, "edit");
                }
            }
        }
        if (viewURL != null || editURL != null) {
            jg.writeFieldName(NAME);
            jg.writeStartObject();
            jg.writeStringField(APP_NAME_FIELD, this.getAppName(extension, "view"));
            if (viewURL != null) {
                jg.writeStringField("view", viewURL);
            }
            if (editURL != null) {
                jg.writeStringField("edit", editURL);
            }
            jg.writeBooleanField(LOCKED_FIELD, LockHelper.isLocked(document.getRepositoryName(), document.getId()));
            jg.writeEndObject();
        }
    }

    protected boolean isExtensionSupported(String extension, String action) {
        return WOPIServlet.ACTIONS_TO_URLS.containsKey(Pair.of((Object)action, (Object)extension));
    }

    protected String getWOPIURL(DocumentModel doc, String action) {
        return String.format("%s%s/%s/%s/%s", this.ctx.getBaseUrl(), NAME, action, doc.getRepositoryName(), doc.getId());
    }

    protected String getAppName(String extension, String action) {
        Pair<String, String> pair = WOPIServlet.ACTIONS_TO_URLS.get(Pair.of((Object)action, (Object)extension));
        if (pair != null) {
            return (String)pair.getLeft();
        }
        return "Word";
    }
}

