/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine.adapter;

import java.util.HashMap;
import javax.ws.rs.GET;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.mobile.webengine.document.MobileDocument;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="preview", type="Preview", targetType="MobileDocument")
public class PreviewAdapter
extends DefaultMobileAdapter {
    private static final Log log = LogFactory.getLog(PreviewAdapter.class);
    private String nuxeoContextPath;

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    public String getPreviewURL() {
        Resource targetObject = this.ctx.getTargetObject();
        if (!(targetObject instanceof MobileDocument)) {
            throw new WebException("Target Object must be MobileDocument");
        }
        return this.getNuxeoContextPath() + "/" + PreviewHelper.getPreviewURL((DocumentModel)((MobileDocument)targetObject).getDocument());
    }

    public String getPreviewContent() throws PropertyException, ClientException {
        Resource targetObject = this.ctx.getTargetObject();
        if (!(targetObject instanceof MobileDocument)) {
            throw new WebException("Target Object must be MobileDocument");
        }
        DocumentModel document = ((MobileDocument)targetObject).getDocument();
        if (!document.hasSchema("note")) {
            throw new WebException("Can't produce preview for this document type");
        }
        String content = (String)((Object)document.getPropertyValue("note:note"));
        String mimetype = (String)((Object)document.getPropertyValue("note:mime_type"));
        return this.convertToHtml(content, mimetype);
    }

    private String convertToHtml(String text, String mimeType) {
        SimpleBlobHolder bh = new SimpleBlobHolder(Blobs.createBlob((String)text, (String)mimeType, (String)"UTF-8"));
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("bodyContentOnly", Boolean.TRUE);
        try {
            bh = ((ConversionService)Framework.getLocalService(ConversionService.class)).convertToMimeType("text/html", (BlobHolder)bh, parameters);
            text = bh.getBlob().getString();
        }
        catch (Exception e) {
            log.error((Object)"Failed to convert to HTML.", (Throwable)e);
        }
        return text;
    }

    private String getNuxeoContextPath() {
        if (this.nuxeoContextPath == null) {
            this.nuxeoContextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        }
        return this.nuxeoContextPath;
    }
}

