/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.mobile.ApplicationDefinitionService;
import org.nuxeo.ecm.mobile.filter.RequestAdapter;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;

public class ApplicationFormAuthenticator
implements NuxeoAuthenticationPlugin {
    protected static final Log log = LogFactory.getLog(ApplicationFormAuthenticator.class);
    private ApplicationDefinitionService service;
    private String usernameKey = "user_name";
    private String passwordKey = "user_password";

    public ApplicationDefinitionService getService() {
        if (this.service == null) {
            this.service = (ApplicationDefinitionService)Framework.getLocalService(ApplicationDefinitionService.class);
        }
        return this.service;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.get("UsernameKey") != null) {
            this.usernameKey = parameters.get("UsernameKey");
        }
        if (parameters.get("PasswordKey") != null) {
            this.passwordKey = parameters.get("PasswordKey");
        }
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        if (this.getService().getApplicationBaseURL(httpRequest) != null) {
            return true;
        }
        log.debug((Object)"No Application match this request, next authenticator to expose login prompt");
        return false;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        Map<String, String> parameters;
        log.debug((Object)("Login Prompt - URL :" + httpRequest.getRequestURL() + "?" + httpRequest.getQueryString()));
        String loginPage = this.getService().getLoginURL(httpRequest);
        if (loginPage == null) {
            log.debug((Object)"No Application matched for this request context, so next Authenticator in Chain will be used");
            return Boolean.FALSE;
        }
        log.debug((Object)("Application matched for this request context so login page used will be the target application detected: " + loginPage));
        try {
            RequestAdapter adapter = new RequestAdapter(httpRequest);
            parameters = adapter.getParametersAndAddTargetURLIfNotSet();
            parameters.remove(this.passwordKey);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e, (Throwable)e);
            return Boolean.FALSE;
        }
        String redirectUrl = URIUtils.addParametersToURIQuery((String)loginPage, parameters);
        try {
            httpResponse.sendRedirect(redirectUrl);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        List<String> result = this.getService().getUnAuthenticatedURLPrefix();
        log.debug((Object)("List of skipped URL:" + result));
        return result;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Map<String, String> parameters;
        if (this.getService().getApplicationBaseURL(httpRequest) == null) {
            log.debug((Object)"No Application match this request, use next Authenticator in chain to retrieve identity");
            return null;
        }
        try {
            RequestAdapter adapter = new RequestAdapter(httpRequest);
            parameters = adapter.getParametersAndAddTargetURLIfNotSet();
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
        String userName = parameters.get(this.usernameKey);
        String password = parameters.get(this.passwordKey);
        if (parameters.get("form_submitted_marker") != null && (userName == null || userName.length() == 0)) {
            parameters.put("org.nuxeo.ecm.login.error", "username.missing");
        }
        if (userName == null || userName.length() == 0) {
            return null;
        }
        return new UserIdentificationInfo(userName, password);
    }
}

