/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.mobile.webengine;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.mobile.webengine.adapter.DefaultMobileAdapter;
import org.nuxeo.ecm.mobile.webengine.document.MobileDocument;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="mobile")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="MobileApplication")
public class MobileApplication
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(MobileApplication.class);
    private String nuxeoContextPath;
    private DocumentViewCodecManager codecManager;
    private UserWorkspaceService userWorkspaceService;
    protected static final Pattern CORDOVA_USER_AGENT_REGEXP = Pattern.compile("Cordova/(.+?) \\((.*)\\)");

    protected void initialize(Object ... args) {
        HashMap<String, Object> context = null;
        String userAgent = this.getContext().getRequest().getHeader("User-Agent");
        if (StringUtils.isEmpty((String)userAgent)) {
            log.debug((Object)"User-Agent empty: assuming not on a mobile device.");
            return;
        }
        Matcher matcher = CORDOVA_USER_AGENT_REGEXP.matcher(userAgent);
        if (matcher.find()) {
            context = new HashMap<String, Object>();
            context.put("version", matcher.group(1));
            context.put("device", matcher.group(2));
            context.put("isIOS", matcher.group(2).matches("iOS"));
            context.put("isAndroid", matcher.group(2).matches("android"));
            log.info((Object)"Cordova User-Agent detected");
        }
        this.getContext().setProperty("Cordova", context);
    }

    @GET
    public Object doGet(@QueryParam(value="targetURL") String initialURL) throws Exception {
        DocumentView docView;
        if (initialURL != null && (docView = this.getCodecManager().getDocumentViewFromUrl(initialURL, true, "")) != null) {
            log.debug((Object)("Request from home: Target URL given into url parameter detected as a document request from url codec service: " + initialURL));
            MobileDocument docResolved = new MobileDocument(this.ctx, docView.getDocumentLocation().getDocRef());
            return docResolved.doGet();
        }
        if (this.getSocialObject() != null) {
            return this.redirect(this.ctx.getBaseURL() + this.ctx.getBasePath() + "/mobile/social");
        }
        HashMap<String, DocumentModelList> args = new HashMap<String, DocumentModelList>();
        args.put("userWorkspace", this.getUserWorkspacesDocs());
        return this.getView("index").args(args);
    }

    @Path(value="auth")
    public Object doTraverseAuthentication() {
        return this.ctx.newObject("WebMobileAuthentication", new Object[0]);
    }

    @Path(value="profile")
    public Object doTraverseProfile() {
        return this.ctx.newObject("Profile", new Object[0]);
    }

    @GET
    @Path(value="root")
    public Object getRootRepositoryView() throws Exception {
        DocumentModelList children;
        HashMap<String, DocumentModelList> args = new HashMap<String, DocumentModelList>();
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel doc = session.getRootDocument();
        do {
            if ((children = session.getChildren(doc.getRef(), null, DefaultMobileAdapter.ONLY_VISIBLE_CHILDREN, null)).size() != 1) continue;
            doc = (DocumentModel)children.get(0);
        } while (children.size() == 1);
        args.put("domain", children);
        return this.getView("root").args(args);
    }

    @Path(value="docPath/@{adapter}")
    public Object doTraverseRootDocumentByPath(@PathParam(value="adapter") String adapter) {
        PathRef ref = new PathRef("/");
        if ("search".equals(adapter)) {
            return new MobileDocument(this.ctx, (DocumentRef)ref).search();
        }
        return new MobileDocument(this.ctx, (DocumentRef)ref).disptachAdapter(adapter);
    }

    @Path(value="docPath{docPathValue:(/(?:(?!/@).)*)}")
    public Object doTraverseDocumentByPath(@PathParam(value="docPathValue") String docPath) {
        PathRef ref = new PathRef(docPath);
        return new MobileDocument(this.ctx, (DocumentRef)ref);
    }

    @Path(value="doc/{docId}")
    public Object doTraverseDocument(@PathParam(value="docId") String docId) {
        IdRef ref = new IdRef(docId);
        return new MobileDocument(this.ctx, (DocumentRef)ref);
    }

    @Path(value="search")
    public Object doTraverseSearch() {
        return this.ctx.newObject("Search", new Object[0]);
    }

    @Path(value="task")
    @Deprecated
    public Object doTraverseTask() {
        return null;
    }

    @Path(value="activity")
    public Object doTraverseActivity() {
        return this.ctx.newObject("Activity", new Object[0]);
    }

    @Path(value="social")
    public Object doSocial() {
        return this.ctx.newObject("Social", new Object[0]);
    }

    public String getNuxeoContextPath() {
        if (this.nuxeoContextPath == null) {
            this.nuxeoContextPath = Framework.getProperty((String)"org.nuxeo.ecm.contextPath");
        }
        return this.nuxeoContextPath;
    }

    protected DocumentModelList getUserWorkspacesDocs() throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        return session.getChildren(userWorkspace.getRef(), null, DefaultMobileAdapter.ONLY_VISIBLE_CHILDREN, null);
    }

    protected Object getSocialObject() {
        try {
            return this.ctx.newObject("Social", new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    protected DocumentViewCodecManager getCodecManager() throws Exception {
        if (this.codecManager == null) {
            this.codecManager = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        }
        return this.codecManager;
    }

    protected UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }
}

