/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.snapshot.Snapshot;

public class SnapshotableAdapter
implements Snapshot,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DocumentModel doc;
    public static final String SCHEMA = "snapshot";
    public static final String CHILDREN_PROP = "snap:children";
    public static final String NAME_PROP = "snap:originalName";

    public SnapshotableAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    @Override
    public DocumentRef getRef() {
        return this.doc.getRef();
    }

    protected DocumentRef createLeafVersion(DocumentModel targetDoc, VersioningOption option) {
        if (targetDoc.isFolder() && !targetDoc.hasSchema(SCHEMA)) {
            throw new NuxeoException("Can not version a folder that has not snapshot schema");
        }
        if (targetDoc.isVersion()) {
            return targetDoc.getRef();
        }
        if (!targetDoc.isProxy() && !targetDoc.isCheckedOut()) {
            return targetDoc.getCoreSession().getLastDocumentVersionRef(targetDoc.getRef());
        }
        if (targetDoc.isProxy()) {
            DocumentModel proxyTarget = targetDoc.getCoreSession().getDocument((DocumentRef)new IdRef(targetDoc.getSourceId()));
            if (proxyTarget.isVersion()) {
                return targetDoc.getRef();
            }
            return this.createLeafVersion(proxyTarget, option);
        }
        DocumentEventContext ctx = new DocumentEventContext(targetDoc.getCoreSession(), targetDoc.getCoreSession().getPrincipal(), targetDoc);
        ctx.setProperty("leafRootDocument", (Serializable)this.doc);
        ((EventService)Framework.getLocalService(EventService.class)).fireEvent(ctx.newEvent("aboutToCreateLeafVersionEvent"));
        if (targetDoc.isDirty()) {
            targetDoc.getCoreSession().saveDocument(targetDoc);
        }
        return targetDoc.getCoreSession().checkIn(targetDoc.getRef(), option, null);
    }

    protected DocumentModel createLeafVersionAndFetch(VersioningOption option) {
        DocumentRef versionRef = this.createLeafVersion(this.doc, option);
        DocumentModel version = this.doc.getCoreSession().getDocument(versionRef);
        return version;
    }

    @Override
    public Snapshot createSnapshot(VersioningOption option) {
        if (!this.doc.isFolder()) {
            if (this.doc.isCheckedOut()) {
                return new SnapshotableAdapter(this.createLeafVersionAndFetch(option));
            }
            return new SnapshotableAdapter(this.doc);
        }
        if (!this.doc.hasFacet("Snapshot")) {
            this.doc.addFacet("Snapshot");
        }
        if (!this.doc.hasFacet("Versionable")) {
            this.doc.addFacet("Versionable");
        }
        DocumentModelList children = this.doc.getCoreSession().getChildren(this.doc.getRef());
        Object[] vuuids = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            DocumentModel child = (DocumentModel)children.get(i);
            if (!child.isFolder()) {
                DocumentRef leafRef = this.createLeafVersion(child, option);
                vuuids[i] = leafRef.toString();
                continue;
            }
            SnapshotableAdapter adapter = new SnapshotableAdapter(child);
            Snapshot snap = adapter.createSnapshot(option);
            vuuids[i] = snap.getRef().toString();
        }
        boolean mustSnapshot = false;
        if (this.doc.isCheckedOut()) {
            mustSnapshot = true;
        } else {
            Object[] existingUUIds = (String[])this.doc.getPropertyValue(CHILDREN_PROP);
            if (this.doc.hasFacet("Orderable")) {
                if (!Arrays.equals(vuuids, existingUUIds)) {
                    mustSnapshot = true;
                }
            } else if (!new HashSet<Object>(Arrays.asList(vuuids)).equals(new HashSet<Object>(Arrays.asList(existingUUIds)))) {
                mustSnapshot = true;
            }
        }
        if (mustSnapshot) {
            this.doc.setPropertyValue(CHILDREN_PROP, (Serializable)vuuids);
            this.doc.setPropertyValue(NAME_PROP, (Serializable)((Object)this.doc.getName()));
            this.doc = this.doc.getCoreSession().saveDocument(this.doc);
            return new SnapshotableAdapter(this.createLeafVersionAndFetch(option));
        }
        DocumentModel lastversion = this.doc.getCoreSession().getLastDocumentVersion(this.doc.getRef());
        return new SnapshotableAdapter(lastversion);
    }

    protected List<DocumentModel> getChildren(DocumentModel target) {
        if (!target.isVersion()) {
            throw new NuxeoException("Not a version:");
        }
        if (!target.isFolder()) {
            return Collections.emptyList();
        }
        if (target.isFolder() && !target.hasSchema(SCHEMA)) {
            throw new NuxeoException("Folderish children should have the snapshot schema");
        }
        try {
            String[] uuids = (String[])target.getPropertyValue(CHILDREN_PROP);
            if (uuids != null && uuids.length > 0) {
                DocumentRef[] refs = new DocumentRef[uuids.length];
                for (int i = 0; i < uuids.length; ++i) {
                    refs[i] = new IdRef(uuids[i]);
                }
                return target.getCoreSession().getDocuments(refs);
            }
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    @Override
    public List<DocumentModel> getChildren() {
        return this.getChildren(this.doc);
    }

    @Override
    public List<Snapshot> getChildrenSnapshots() {
        ArrayList<Snapshot> snaps = new ArrayList<Snapshot>();
        for (DocumentModel child : this.getChildren()) {
            snaps.add(new SnapshotableAdapter(child));
        }
        return snaps;
    }

    protected void fillFlatTree(List<Snapshot> list) {
        for (Snapshot snap : this.getChildrenSnapshots()) {
            list.add(snap);
            if (!snap.getDocument().isFolder()) continue;
            ((SnapshotableAdapter)snap).fillFlatTree(list);
        }
    }

    @Override
    public List<Snapshot> getFlatTree() {
        ArrayList<Snapshot> list = new ArrayList<Snapshot>();
        this.fillFlatTree(list);
        return list;
    }

    protected void dump(int level, StringBuffer sb) {
        for (Snapshot snap : this.getChildrenSnapshots()) {
            sb.append(new String(new char[level]).replace('\u0000', ' '));
            sb.append(snap.getDocument().getName() + " -- " + snap.getDocument().getVersionLabel());
            sb.append("\n");
            if (!snap.getDocument().isFolder()) continue;
            ((SnapshotableAdapter)snap).dump(level + 1, sb);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.doc.getName() + " -- " + this.doc.getVersionLabel());
        sb.append("\n");
        this.dump(1, sb);
        return sb.toString();
    }

    protected DocumentModel getVersionForLabel(DocumentModel target, String versionLabel) {
        List versions = target.getCoreSession().getVersions(target.getRef());
        for (DocumentModel version : versions) {
            if (!version.getVersionLabel().equals(versionLabel)) continue;
            return version;
        }
        return null;
    }

    protected DocumentModel getCheckoutDocument(DocumentModel target) {
        if (target.isVersion()) {
            target = target.getCoreSession().getDocument((DocumentRef)new IdRef(this.doc.getSourceId()));
        }
        return target;
    }

    protected DocumentModel restore(DocumentModel leafVersion, DocumentModel target, boolean first, DocumentModelList olddocs) {
        CoreSession session = this.doc.getCoreSession();
        if (leafVersion == null) {
            return null;
        }
        if (target.isFolder() && first && (olddocs = session.query("select * from Document where ecm:path STARTSWITH '" + target.getPathAsString() + "'")).size() > 0) {
            DocumentModel container = session.createDocumentModel(target.getPath().removeLastSegments(1).toString(), target.getName() + "_tmp", "Folder");
            container = session.createDocument(container);
            for (DocumentModel oldChild : olddocs) {
                session.move(oldChild.getRef(), container.getRef(), oldChild.getName());
            }
            olddocs.add((Object)container);
        }
        target = session.restoreToVersion(target.getRef(), leafVersion.getRef());
        for (DocumentModel child : this.getChildren(leafVersion)) {
            String liveUUID = child.getVersionSeriesId();
            DocumentModel placeholder = null;
            for (DocumentModel doc : olddocs) {
                if (!doc.getId().equals(liveUUID)) continue;
                placeholder = doc;
                break;
            }
            if (placeholder == null && session.exists((DocumentRef)new IdRef(liveUUID))) {
                placeholder = session.getDocument((DocumentRef)new IdRef(liveUUID));
            }
            if (placeholder != null) {
                olddocs.remove(placeholder);
                session.move(placeholder.getRef(), target.getRef(), placeholder.getName());
            } else {
                String name = child.getName();
                if (name == null && child.hasSchema(SCHEMA)) {
                    name = (String)((Object)child.getPropertyValue(NAME_PROP));
                }
                if (name == null && child.getTitle() != null) {
                    name = IdUtils.generateId((String)child.getTitle(), (String)"-", (boolean)true, (int)24);
                }
                if (name == null) {
                    name = child.getType() + System.currentTimeMillis();
                }
                placeholder = new DocumentModelImpl((String)null, child.getType(), liveUUID, new Path(name), null, null, target.getRef(), null, null, null, null);
                placeholder.putContextData("ecm:isCheckedIn", (Serializable)Boolean.TRUE);
                placeholder.addFacet("Snapshot");
                placeholder.addFacet("Versionable");
                session.importDocuments(Collections.singletonList(placeholder));
                placeholder = session.getDocument((DocumentRef)new IdRef(liveUUID));
            }
            new SnapshotableAdapter(child).restore(child, placeholder, false, olddocs);
        }
        if (first) {
            for (DocumentModel old : olddocs) {
                session.removeDocument(old.getRef());
            }
        }
        return target;
    }

    @Override
    public DocumentModel restore(String versionLabel) {
        DocumentModel target = this.getCheckoutDocument(this.doc);
        DocumentModel leafVersion = this.getVersionForLabel(target, versionLabel);
        DocumentModel restoredDoc = this.restore(leafVersion, target, true, null);
        return restoredDoc;
    }
}

