/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.automation;

import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

@Operation(id="TemplateProcessor.Detach", category="Conversion", label="Detach a template", description="Detach a template from all its bound documents.")
public class DetachTemplateOperation {
    public static final String ID = "TemplateProcessor.Detach";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run(DocumentModel targetTemplate) {
        TemplateSourceDocument template = (TemplateSourceDocument)targetTemplate.getAdapter(TemplateSourceDocument.class);
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
        List documents = template.getTemplateBasedDocuments();
        documents.forEach(doc -> tps.detachTemplateBasedDocument(doc.getAdaptedDoc(), template.getName(), true));
    }
}

