/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.jxls;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.context.SimpleContextBuilder;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.jxls.JXLSBindingResolver;

public class JXLSTemplateProcessor
extends AbstractTemplateProcessor {
    public static final String TEMPLATE_TYPE = "JXLS";
    protected SimpleContextBuilder contextBuilder = new SimpleContextBuilder();

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws IOException {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        List params = templateBasedDocument.getParams(templateName);
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        Map ctx = this.contextBuilder.build(doc, templateName);
        JXLSBindingResolver resolver = new JXLSBindingResolver();
        resolver.resolve(params, ctx, templateBasedDocument);
        File workingDir = this.getWorkingDir();
        File generated = new File(workingDir, "JXLSresult-" + System.currentTimeMillis());
        generated.createNewFile();
        File input = new File(workingDir, "JXLSInput-" + System.currentTimeMillis());
        input.createNewFile();
        sourceTemplateBlob.transferTo(input);
        XLSTransformer transformer = new XLSTransformer();
        this.configureTransformer(transformer);
        try {
            transformer.transformXLS(input.getAbsolutePath(), ctx, generated.getAbsolutePath());
        }
        catch (ParsePropertyException | InvalidFormatException e) {
            throw new NuxeoException(e);
        }
        input.delete();
        Blob newBlob = Blobs.createBlob((File)generated);
        String templateFileName = sourceTemplateBlob.getFilename();
        String targetFileExt = FileUtils.getFileExtension((String)templateFileName);
        String targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        targetFileName = targetFileName + "." + targetFileExt;
        newBlob.setFilename(targetFileName);
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        newBlob.setMimeType(mimetypeRegistry.getMimetypeFromExtension(targetFileExt));
        Framework.trackFile((File)generated, (Object)newBlob);
        return newBlob;
    }

    protected void configureTransformer(XLSTransformer transformer) {
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) {
        return new ArrayList<TemplateInput>();
    }
}

