/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.internal;

import fr.opensagres.xdocreport.core.internal.IXMLPrettyPrinter;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTPrettyPrinter
implements IXMLPrettyPrinter {
    public static final IXMLPrettyPrinter INSTANCE = new XSLTPrettyPrinter();
    private static final String XSLT_PRETTY_PRINTER = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"  xmlns:xalan=\"http://xml.apache.org/xslt\"  exclude-result-prefixes=\"xalan\">  <xsl:output method=\"xml\" indent=\"yes\" xalan:indent-amount=\"{0}\" omit-xml-declaration=\"yes\"/>  <xsl:strip-space elements=\"*\"/>  <xsl:template match=\"/\">    <xsl:apply-templates/>  </xsl:template>  <xsl:template match=\"node() | @*\">        <xsl:copy>          <xsl:apply-templates select=\"node() | @*\"/>        </xsl:copy>  </xsl:template></xsl:stylesheet>";
    private final Map<Integer, Templates> templates = new HashMap<Integer, Templates>();

    public String prettyPrint(String xml, int indent) throws Exception {
        Transformer transformer = this.getTemplates(indent).newTransformer();
        StringWriter out = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(out));
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates(int indent) throws TransformerConfigurationException {
        Templates t = this.templates.get(indent);
        if (t == null) {
            Map<Integer, Templates> map = this.templates;
            synchronized (map) {
                String xsl = MessageFormat.format(XSLT_PRETTY_PRINTER, indent);
                StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(xsl.getBytes()));
                TransformerFactory factory = TransformerFactory.newInstance();
                t = factory.newTemplates(stylesheetSource);
                this.templates.put(indent, t);
            }
        }
        return t;
    }
}

