/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.internal;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDKServiceLoader {
    private static final Logger LOGGER;
    private static JDKServiceLoader JDK_SERVICE_LOADER;

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass, ClassLoader loader) {
        try {
            return JDK_SERVICE_LOADER.lookupProvidersFromJDK(providerClass, loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract <T> Iterator<T> lookupProvidersFromJDK(Class<T> var1, ClassLoader var2) throws Exception;

    static {
        block6: {
            LOGGER = LogUtils.getLogger(JDKServiceLoader.class.getName());
            ClassLoader classLoader = JDKServiceLoader.class.getClassLoader();
            try {
                JDK_SERVICE_LOADER = new JDK6ServiceLoader(classLoader);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Uses JDK6 java.util.ServiceLoader to load services.");
                }
            }
            catch (Throwable e) {
                try {
                    JDK_SERVICE_LOADER = new JDK5ServiceLoader(classLoader);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Uses JDK5 javax.imageio.spi.ServiceRegistry to load services.");
                    }
                }
                catch (Throwable e1) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block6;
                    LOGGER.log(Level.SEVERE, "Error while initialization of JDKServiceLoader", e1);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JDK6ServiceLoader
    extends JDKServiceLoader {
        private Method loadMethod;
        private Method iteratorMethod;

        public JDK6ServiceLoader(ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
            Class<?> slc = classLoader.loadClass("java.util.ServiceLoader");
            this.loadMethod = slc.getMethod("load", Class.class, ClassLoader.class);
            this.iteratorMethod = slc.getMethod("iterator", new Class[0]);
        }

        @Override
        protected <T> Iterator<T> lookupProvidersFromJDK(Class<T> providerClass, ClassLoader loader) throws Exception {
            Object serviceLoader = this.loadMethod.invoke(null, providerClass, loader);
            return (Iterator)this.iteratorMethod.invoke(serviceLoader, new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JDK5ServiceLoader
    extends JDKServiceLoader {
        private final Method lookupProvidersMethod;

        public JDK5ServiceLoader(ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
            Class<?> slc = classLoader.loadClass("javax.imageio.spi.ServiceRegistry");
            this.lookupProvidersMethod = slc.getMethod("lookupProviders", Class.class, ClassLoader.class);
        }

        @Override
        protected <T> Iterator<T> lookupProvidersFromJDK(Class<T> providerClass, ClassLoader loader) throws Exception {
            return (Iterator)this.lookupProvidersMethod.invoke(null, providerClass, loader);
        }
    }
}

