/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters.doc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.template.XMLSerializer;
import org.nuxeo.template.api.TemplateInput;

public class TemplateBinding {
    public static final String TEMPLATE_NAME_KEY = "templateName";
    public static final String TEMPLATE_DATA_KEY = "templateData";
    public static final String TEMPLATE_ID_KEY = "templateId";
    public static final String TEMPLATE_USE_BLOB_KEY = "useMainContentAsTemplate";
    private String name;
    private String templateId;
    private String data;
    private boolean useMainContentAsTemplate;

    public TemplateBinding() {
    }

    public TemplateBinding(Map<String, Serializable> map) {
        this.name = (String)((Object)map.get(TEMPLATE_NAME_KEY));
        this.templateId = (String)((Object)map.get(TEMPLATE_ID_KEY));
        this.data = (String)((Object)map.get(TEMPLATE_DATA_KEY));
        this.useMainContentAsTemplate = map.get(TEMPLATE_USE_BLOB_KEY) != null ? (Boolean)map.get(TEMPLATE_USE_BLOB_KEY) : false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setData(List<TemplateInput> params) {
        String xml = XMLSerializer.serialize(params);
        this.setData(xml);
    }

    public boolean isUseMainContentAsTemplate() {
        return this.useMainContentAsTemplate;
    }

    public void setUseMainContentAsTemplate(boolean useMainContentAsTemplate) {
        this.useMainContentAsTemplate = useMainContentAsTemplate;
    }

    public void update(TemplateBinding other) {
        this.name = other.name;
        this.templateId = other.templateId;
        this.data = other.data;
        this.useMainContentAsTemplate = other.useMainContentAsTemplate;
    }

    public Map<String, Serializable> getAsMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(TEMPLATE_NAME_KEY, (Serializable)((Object)this.name));
        map.put(TEMPLATE_ID_KEY, (Serializable)((Object)this.templateId));
        map.put(TEMPLATE_DATA_KEY, (Serializable)((Object)this.data));
        map.put(TEMPLATE_USE_BLOB_KEY, Boolean.valueOf(this.useMainContentAsTemplate));
        return map;
    }
}

