/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.xdocreport;

import fr.opensagres.xdocreport.core.document.SyntaxKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.template.processors.AbstractBindingResolver;
import org.nuxeo.template.processors.xdocreport.BlobImageProvider;

public class XDocReportBindingResolver
extends AbstractBindingResolver {
    protected final FieldsMetadata metadata;

    public XDocReportBindingResolver(FieldsMetadata metadata) {
        this.metadata = metadata;
    }

    protected String handleHtmlField(String paramName, String htmlValue) {
        this.metadata.addFieldAsTextStyling(paramName, SyntaxKind.Html);
        return super.handleHtmlField(paramName, htmlValue);
    }

    protected void handleBlobField(String paramName, Blob blobValue) {
        if ("text/html".equals(blobValue.getMimeType())) {
            this.metadata.addFieldAsTextStyling(paramName, SyntaxKind.Html);
        }
    }

    protected Object handlePictureField(String paramName, Blob blobValue) {
        if (blobValue == null) {
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.png");){
                byte[] bin = IOUtils.toByteArray((InputStream)is);
                blobValue = Blobs.createBlob((byte[])bin, (String)"image/png");
                blobValue.setFilename("blank.png");
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to read fake Blob", (Throwable)e);
            }
        }
        BlobImageProvider imgBlob = new BlobImageProvider(blobValue);
        this.metadata.addFieldAsImage(paramName);
        return imgBlob;
    }

    protected Object handleLoop(String paramName, Object value) {
        this.metadata.addFieldAsList(paramName);
        try {
            return this.getWrapper().wrap(value);
        }
        catch (TemplateModelException e) {
            return null;
        }
    }
}

