/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.ods;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.ods.ODSConstants;
import fr.opensagres.xdocreport.document.ods.images.ODSImageRegistry;
import java.io.IOException;
import java.io.Reader;

public class ODSReport
extends AbstractXDocReport
implements ODSConstants {
    private static final long serialVersionUID = 2483470391381344529L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"content.xml", "styles.xml"};

    public String getKind() {
        return DocumentKind.ODS.name();
    }

    protected void registerPreprocessors() {
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    public MimeMapping getMimeMapping() {
        return MIME_MAPPING;
    }

    public static boolean isODS(XDocArchive documentArchive) {
        try {
            if (!documentArchive.hasEntry("mimetype")) {
                return false;
            }
            return "application/vnd.oasis.opendocument.spreadsheet".equals(IOUtils.toString((Reader)documentArchive.getEntryReader("mimetype")));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new ODSImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }
}

