/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;

public abstract class AbstractTemplateProcessor
implements TemplateProcessor {
    protected static final int BUFFER_SIZE = 65536;
    protected static final Log log = LogFactory.getLog(AbstractTemplateProcessor.class);

    protected File getWorkingDir() {
        File workingDir = new File(Environment.getDefault().getTemp(), "NXTemplateProcessor" + System.currentTimeMillis());
        if (workingDir.exists()) {
            FileUtils.deleteQuietly((File)workingDir);
        }
        workingDir.mkdirs();
        Framework.trackFile((File)workingDir, (Object)workingDir);
        return workingDir;
    }

    protected Blob getSourceTemplateBlob(TemplateBasedDocument templateBasedDocument, String templateName) {
        return templateBasedDocument.getTemplateBlob(templateName);
    }
}

