/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.xdocreport.jaxrs;

import fr.opensagres.xdocreport.remoting.resources.domain.LargeBinaryData;
import java.io.IOException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class BinaryDataWrapper {
    public static LargeBinaryData wrap(Blob blob) throws IOException {
        LargeBinaryData data = new LargeBinaryData();
        data.setContent(blob.getStream());
        data.setFileName(blob.getFilename());
        data.setMimeType(blob.getMimeType());
        if (blob.getLength() > 0L) {
            data.setLength(blob.getLength());
        }
        return data;
    }

    public static LargeBinaryData wrap(TemplateSourceDocument template) throws IOException {
        Blob blob = template.getTemplateBlob();
        LargeBinaryData data = BinaryDataWrapper.wrap(blob);
        data.setResourceId(template.getAdaptedDoc().getId());
        return data;
    }

    public static LargeBinaryData wrapXml(String xml, String fileName) throws IOException {
        Blob blob = Blobs.createBlob((String)xml, (String)"text/xml", null, (String)fileName);
        return BinaryDataWrapper.wrap(blob);
    }
}

