/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jxls.formula.FormulaPart;
import net.sf.jxls.formula.ListRange;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.transformer.Sheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Formula {
    protected static final Log log = LogFactory.getLog(Formula.class);
    private static final Map<String, FormulaInfo> cache = new HashMap<String, FormulaInfo>();
    private String formula;
    private Integer rowNum;
    private Integer cellNum;
    static final String inlineFormulaToken = "#";
    static final String formulaListRangeToken = "@";
    private Sheet sheet;
    private Set cellRefs = new HashSet();
    private List formulaParts = new ArrayList();
    private static final String regexFormulaPart = "[a-zA-Z]+[0-9]*\\([^@()]+\\)@[0-9]+";
    private static final Pattern regexFormulaPartPattern = Pattern.compile("[a-zA-Z]+[0-9]*\\([^@()]+\\)@[0-9]+");

    public static void clearCache() {
        cache.clear();
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Formula(String formula, Sheet sheet) {
        this.formula = formula;
        this.sheet = sheet;
        String cacheKey = (sheet != null ? sheet.getSheetName() : "") + "!" + formula;
        FormulaInfo fi = cache.get(cacheKey);
        if (fi == null) {
            this.parseFormula();
            this.updateCellRefs();
            cache.put(cacheKey, new FormulaInfo(this));
        } else {
            int c = fi.formulaParts.size();
            for (int i = 0; i < c; ++i) {
                FormulaPart formulaPart = (FormulaPart)fi.formulaParts.get(i);
                this.formulaParts.add(new FormulaPart(formulaPart, this));
                this.cellRefs = fi.cellRefs;
            }
        }
    }

    public Formula() {
    }

    public Formula(Formula f) {
        this.formula = f.formula;
        this.sheet = f.getSheet();
        int c = f.formulaParts.size();
        for (int i = 0; i < c; ++i) {
            FormulaPart formulaPart = (FormulaPart)f.formulaParts.get(i);
            this.formulaParts.add(new FormulaPart(formulaPart));
        }
        this.updateCellRefs();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getCellNum() {
        return this.cellNum;
    }

    public void setCellNum(Integer cellNum) {
        this.cellNum = cellNum;
    }

    public Set getCellRefs() {
        return this.cellRefs;
    }

    public List getFormulaParts() {
        return this.formulaParts;
    }

    public boolean isInline() {
        return this.formula.indexOf(inlineFormulaToken) >= 0;
    }

    public String getInlineFormula(int n) {
        if (this.isInline()) {
            return this.formula.replaceAll(inlineFormulaToken, Integer.toString(n));
        }
        return this.formula;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAppliedFormula(Map listRanges, Map namedCells) {
        String codedFormula = this.formula;
        StringBuilder appliedFormulaBuilder = new StringBuilder();
        String delimiter = formulaListRangeToken;
        int index = codedFormula.indexOf(delimiter);
        boolean isExpression = false;
        while (true) {
            if (index < 0) {
                appliedFormulaBuilder.append(codedFormula);
                return appliedFormulaBuilder.toString();
            }
            String token = codedFormula.substring(0, index);
            if (isExpression) {
                if (listRanges.containsKey(token)) {
                    appliedFormulaBuilder.append(((ListRange)listRanges.get(token)).toExcelCellRange());
                } else {
                    if (!namedCells.containsKey(token)) {
                        log.warn((Object)("can't find list range or named cell for " + token));
                        return null;
                    }
                    appliedFormulaBuilder.append(((Cell)namedCells.get(token)).toCellName());
                }
            } else {
                appliedFormulaBuilder.append(token);
            }
            codedFormula = codedFormula.substring(index + 1);
            index = codedFormula.indexOf(delimiter);
            isExpression = !isExpression;
        }
    }

    public String getActualFormula() {
        StringBuilder actualFormulaBuilder = new StringBuilder();
        for (FormulaPart formulaPart : this.formulaParts) {
            actualFormulaBuilder.append(formulaPart.getActualFormula());
        }
        return actualFormulaBuilder.toString();
    }

    public Set findRefCells() {
        HashSet refCells = new HashSet();
        for (FormulaPart formulaPart : this.formulaParts) {
            refCells.addAll(formulaPart.getRefCells());
        }
        return refCells;
    }

    private void parseFormula() {
        Matcher formulaPartMatcher = regexFormulaPartPattern.matcher(this.formula);
        int end = 0;
        while (formulaPartMatcher.find()) {
            String formulaPartString = this.formula.substring(end, formulaPartMatcher.start());
            if (formulaPartString.length() > 0) {
                this.formulaParts.add(new FormulaPart(formulaPartString, this));
            }
            this.formulaParts.add(new FormulaPart(formulaPartMatcher.group(), this));
            end = formulaPartMatcher.end();
        }
        String endPart = this.formula.substring(end);
        if (endPart.length() > 0) {
            this.formulaParts.add(new FormulaPart(endPart, this));
        }
        this.updateCellRefs();
    }

    void updateCellRefs() {
        this.cellRefs = this.findRefCells();
    }

    public String toString() {
        return "Formula{formula='" + this.formula + "'" + ", rowNum=" + this.rowNum + ", cellNum=" + this.cellNum + "}";
    }

    public boolean containsListRanges() {
        return this.formula.matches("[^)]*@.*");
    }

    public void removeCellRefs(Set cellRefsToRemove) {
        int c = this.formulaParts.size();
        for (int i = 0; i < c; ++i) {
            FormulaPart formulaPart = (FormulaPart)this.formulaParts.get(i);
            formulaPart.removeCellRefs(cellRefsToRemove);
        }
        this.updateCellRefs();
    }

    public boolean updateReplacedRefCellsCollection() {
        boolean ret = false;
        for (FormulaPart formulaPart : this.formulaParts) {
            if (!formulaPart.updateReplacedRefCellsCollection()) continue;
            ret = true;
        }
        return ret;
    }

    private static class FormulaInfo {
        private List formulaParts = new LinkedList();
        private Set cellRefs = new HashSet();

        private FormulaInfo(Formula formula) {
            int c = formula.formulaParts.size();
            for (int i = 0; i < c; ++i) {
                FormulaPart newpart = new FormulaPart((FormulaPart)formula.formulaParts.get(i));
                this.formulaParts.add(newpart);
                this.cellRefs.addAll(newpart.cellRefs);
            }
        }
    }
}

