/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.rels;

import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkInfo;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering.NumberingRegistry;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Collection;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocxDocumentXMLRelsDocumentContentHandler
extends BufferedDocumentContentHandler {
    private static final String ITEM_INFO = "___info";
    protected final String entryName;
    protected final IDocumentFormatter formatter;
    protected final FieldsMetadata fieldsMetadata;
    private final Map<String, HyperlinkInfo> hyperlinksMap;
    private boolean hyperlinkParsing = false;
    private boolean hasNumbering;

    public DocxDocumentXMLRelsDocumentContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        this.entryName = entryName;
        this.formatter = formatter;
        this.fieldsMetadata = fieldsMetadata;
        this.hyperlinksMap = HyperlinkUtils.getInitialHyperlinkMap(entryName, sharedContext);
        this.hasNumbering = false;
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("Relationship".equals(name)) {
            String type = attributes.getValue("Type");
            if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(type)) {
                if (this.hyperlinksMap != null) {
                    this.hyperlinkParsing = true;
                    return false;
                }
            } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering".equals(type) && !this.hasNumbering) {
                this.hasNumbering = "numbering.xml".equals(attributes.getValue("Target"));
            }
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (this.hyperlinkParsing) {
            this.hyperlinkParsing = false;
            return;
        }
        if ("Relationships".equals(name)) {
            StringBuilder script = new StringBuilder();
            this.generateScriptsForDynamicImages(script);
            this.generateScriptsForStaticHyperlinks(script);
            this.generateScriptsForDynamicHyperlinks(script);
            this.generateNumberingRelationShip(script);
            BufferedElement currentRegion = this.getCurrentElement();
            currentRegion.append(script.toString());
        }
        super.doEndElement(uri, localName, name);
    }

    private void generateNumberingRelationShip(StringBuilder script) {
        if (!this.hasNumbering && NumberingRegistry.hasDynamicNumbering(this.fieldsMetadata)) {
            String relationId = "xdocreportNumbering";
            String target = "numbering.xml";
            this.generateRelationship(script, relationId, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering", target, null);
        }
    }

    private void generateScriptsForDynamicImages(StringBuilder script) {
        String startIf = this.formatter.getStartIfDirective("___ImageRegistry");
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, new String[]{"___ImageRegistry", "ImageProviderInfos"});
        String itemListInfos = this.formatter.formatAsSimpleField(false, new String[]{ITEM_INFO});
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String relationId = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageId"});
        String target = "media/" + this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageFileName"});
        this.generateRelationship(script, relationId, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", target, null);
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("___ImageRegistry"));
    }

    private void generateScriptsForStaticHyperlinks(StringBuilder script) {
        if (this.hyperlinksMap != null) {
            Collection<HyperlinkInfo> hyperlinks = this.hyperlinksMap.values();
            for (HyperlinkInfo hyperlink : hyperlinks) {
                this.generateRelationship(script, hyperlink.getId(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink", hyperlink.getTarget(), hyperlink.getTargetMode());
            }
        }
    }

    private void generateScriptsForDynamicHyperlinks(StringBuilder script) {
        String registryKey = HyperlinkUtils.getHyperlinkRegistryKey(HyperlinkUtils.getEntryNameWithoutRels(this.entryName));
        String startIf = this.formatter.getStartIfDirective(registryKey);
        script.append(startIf);
        String listInfos = this.formatter.formatAsSimpleField(false, new String[]{registryKey, "Hyperlinks"});
        String itemListInfos = this.formatter.formatAsSimpleField(false, new String[]{ITEM_INFO});
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String relationId = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "Id"});
        String target = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "Target"});
        String targetMode = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "TargetMode"});
        this.generateRelationship(script, relationId, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink", target, targetMode);
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
        script.append(this.formatter.getEndIfDirective("___HyperlinkRegistry"));
    }

    protected void generateRelationship(StringBuilder script, String relationId, String type, String target, String targetMode) {
        script.append("<");
        script.append("Relationship");
        script.append(" ");
        script.append("Id");
        script.append("=\"");
        script.append(relationId);
        script.append("\" ");
        script.append("Type");
        script.append("=\"");
        script.append(type);
        script.append("\" ");
        script.append("Target");
        script.append("=\"");
        script.append(target);
        if (targetMode != null) {
            script.append("\" ");
            script.append("TargetMode");
            script.append("=\"");
            script.append(targetMode);
        }
        script.append("\" />");
    }
}

