/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.odt;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;

public class OOoArchiveModifier {
    public File updateArchive(File workingDir, File oooFile, List<Blob> blobs) throws Exception {
        File contentDirs;
        if (blobs == null || blobs.size() == 0) {
            return oooFile;
        }
        File unzipDir = new File(workingDir, "unzip-" + oooFile.getName());
        unzipDir.mkdirs();
        ZipUtils.unzip((File)oooFile, (File)unzipDir);
        File pictureDirs = new File(unzipDir, "Pictures");
        if (!pictureDirs.exists()) {
            pictureDirs.mkdir();
            pictureDirs = new File(unzipDir, "Pictures");
        }
        if (!(contentDirs = new File(unzipDir, "Content")).exists()) {
            contentDirs.mkdir();
            contentDirs = new File(unzipDir, "Content");
        }
        StringBuffer blobsManifest = new StringBuffer();
        for (Blob blob : blobs) {
            if (blob.getMimeType().startsWith("image")) {
                FileUtils.copyToFile((InputStream)blob.getStream(), (File)new File(pictureDirs, blob.getFilename()));
            } else {
                FileUtils.copyToFile((InputStream)blob.getStream(), (File)new File(contentDirs, blob.getFilename()));
            }
            blobsManifest.append("<manifest:file-entry manifest:media-type=\"");
            blobsManifest.append(blob.getMimeType());
            if (blob.getMimeType().startsWith("image")) {
                blobsManifest.append("\" manifest:full-path=\"Pictures/");
            } else {
                blobsManifest.append("\" manifest:full-path=\"Content/");
            }
            blobsManifest.append(blob.getFilename());
            blobsManifest.append("\"/>\n");
        }
        File xmlManifestFile = new File(unzipDir.getPath() + "/META-INF/manifest.xml");
        String xmlManifest = FileUtils.readFile((File)xmlManifestFile);
        int idx = xmlManifest.indexOf("</manifest:manifest>");
        xmlManifest = xmlManifest.substring(0, idx) + blobsManifest.toString() + xmlManifest.substring(idx);
        FileUtils.writeFile((File)xmlManifestFile, (byte[])xmlManifest.getBytes());
        String path = oooFile.getAbsolutePath();
        oooFile.delete();
        oooFile = new File(path);
        oooFile.createNewFile();
        this.mkOOoZip(unzipDir, oooFile);
        FileUtils.deleteTree((File)unzipDir);
        return oooFile;
    }

    protected void mkOOoZip(File directory, File outFile) throws Exception {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(outFile));
        File manif = new File(directory, "mimetype");
        this.writeOOoEntry(zipOutputStream, manif.getName(), manif, 0);
        for (File fileEntry : directory.listFiles()) {
            if (fileEntry.getName().equals(manif.getName())) continue;
            this.writeOOoEntry(zipOutputStream, fileEntry.getName(), fileEntry, 8);
        }
        zipOutputStream.close();
    }

    protected void writeOOoEntry(ZipOutputStream zipOutputStream, String entryName, File fileEntry, int zipMethod) throws Exception {
        if (fileEntry.isDirectory()) {
            entryName = entryName + "/";
            ZipEntry zentry = new ZipEntry(entryName);
            zipOutputStream.putNextEntry(zentry);
            zipOutputStream.closeEntry();
            for (File child : fileEntry.listFiles()) {
                this.writeOOoEntry(zipOutputStream, entryName + child.getName(), child, zipMethod);
            }
            return;
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        FileInputStream entryInputStream = new FileInputStream(fileEntry);
        zipEntry.setMethod(zipMethod);
        if (zipMethod == 0) {
            byte[] inputBytes = FileUtils.readBytes((InputStream)entryInputStream);
            CRC32 crc = new CRC32();
            crc.update(inputBytes);
            zipEntry.setCrc(crc.getValue());
            zipEntry.setSize(inputBytes.length);
            zipEntry.setCompressedSize(inputBytes.length);
            zipOutputStream.putNextEntry(zipEntry);
            FileUtils.copy((InputStream)new ByteArrayInputStream(inputBytes), (OutputStream)zipOutputStream);
        } else {
            zipOutputStream.putNextEntry(zipEntry);
            FileUtils.copy((InputStream)entryInputStream, (OutputStream)zipOutputStream);
        }
        try {
            ((InputStream)entryInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        zipOutputStream.closeEntry();
    }
}

