/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.web;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.web.BaseTemplateAction;

@Name(value="templateBasedActions")
@Scope(value=ScopeType.CONVERSATION)
public class TemplateBasedActionBean
extends BaseTemplateAction {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected List<TemplateInput> templateInputs;
    protected List<TemplateInput> templateEditableInputs;
    protected TemplateInput newInput;
    protected String templateIdToAssociate;
    protected String editableTemplateName;

    public String createTemplate() throws Exception {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        TemplateSourceDocument sourceTemplate = (TemplateSourceDocument)changeableDocument.getAdapter(TemplateSourceDocument.class);
        if (sourceTemplate != null && sourceTemplate.getTemplateBlob() != null) {
            try {
                sourceTemplate.initTemplate(false);
                if (sourceTemplate.hasEditableParams()) {
                    this.templateInputs = sourceTemplate.getParams();
                    return "editTemplateRelatedData";
                }
            }
            catch (Exception e) {
                log.error((Object)"Error during parameter automatic initialization", (Throwable)e);
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.template.err.parameterInit"), new Object[0]);
            }
        }
        return this.documentActions.saveDocument(changeableDocument);
    }

    public List<TemplateInput> getTemplateInputs() {
        return this.templateInputs;
    }

    public void setTemplateInputs(List<TemplateInput> templateInputs) {
        this.templateInputs = templateInputs;
    }

    public String saveDocument() throws Exception {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        for (TemplateInput ti : this.templateInputs) {
            log.info((Object)ti.toString());
        }
        TemplateSourceDocument source = (TemplateSourceDocument)changeableDocument.getAdapter(TemplateSourceDocument.class);
        if (source != null) {
            source.saveParams(this.templateInputs, false);
        }
        return this.documentActions.saveDocument(changeableDocument);
    }

    @Observer(value={"documentSelectionChanged", "changeableDocumentCreated", "documentChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.templateInputs = null;
        this.templateEditableInputs = null;
        this.editableTemplateName = null;
        this.templateIdToAssociate = null;
    }

    public List<TemplateInput> getTemplateEditableInputs() throws Exception {
        if (this.editableTemplateName == null) {
            return new ArrayList<TemplateInput>();
        }
        if (this.templateEditableInputs == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            TemplateBasedDocument templateBasedDoc = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
            this.templateEditableInputs = templateBasedDoc.getParams(this.editableTemplateName);
        }
        return this.templateEditableInputs;
    }

    public void setTemplateEditableInputs(List<TemplateInput> templateEditableInputs) {
        this.templateEditableInputs = templateEditableInputs;
    }

    public String saveTemplateInputs() throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateBasedDocument template = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (template != null) {
            currentDocument = template.saveParams(this.editableTemplateName, this.templateEditableInputs, true);
        }
        this.reset();
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public void cancelTemplateInputsEdit() throws Exception {
        this.reset();
    }

    public TemplateInput getNewInput() {
        if (this.newInput == null) {
            this.newInput = new TemplateInput("newField");
        }
        return this.newInput;
    }

    public void setNewInput(TemplateInput newInput) {
        this.newInput = newInput;
    }

    public String addTemplateInput() throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template == null) {
            return null;
        }
        template.addInput(this.newInput);
        this.newInput = null;
        this.templateEditableInputs = null;
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public String render(String templateName) throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateBasedDocument doc = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (doc == null) {
            return null;
        }
        try {
            Blob rendition = doc.renderWithTemplate(templateName);
            String filename = rendition.getFilename();
            ComponentUtils.download((DocumentModel)currentDocument, null, (Blob)rendition, (String)filename, (String)"templateRendition");
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Unable to render template ", (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.template.err.renderingFailed"), new Object[0]);
            return null;
        }
    }

    public String renderAndStore(String templateName) throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateBasedDocument doc = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (doc == null) {
            return null;
        }
        doc.renderAndStoreAsAttachment(templateName, true);
        this.documentManager.save();
        return this.navigationContext.navigateToDocument(doc.getAdaptedDoc());
    }

    @Override
    public boolean canResetParameters() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        TemplateBasedDocument templateBased = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        return templateBased != null;
    }

    public void resetParameters(String templateName) throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateBasedDocument templateBased = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (templateBased != null) {
            templateBased.initializeFromTemplate(templateName, true);
            this.templateEditableInputs = null;
        }
    }

    public boolean canDetachTemplate(String templateName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        TemplateBasedDocument templateBased = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        return templateBased != null;
    }

    public String detachTemplate(String templateName) throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        DocumentModel detachedDocument = tps.detachTemplateBasedDocument(currentDocument, templateName, true);
        this.webActions.resetTabList();
        this.navigationContext.setCurrentDocument(null);
        return this.navigationContext.navigateToDocument(detachedDocument);
    }

    public String getTemplateIdToAssociate() {
        return this.templateIdToAssociate;
    }

    public void setTemplateIdToAssociate(String templateIdToAssociate) {
        this.templateIdToAssociate = templateIdToAssociate;
    }

    public void associateDocumentToTemplate() throws ClientException {
        if (this.templateIdToAssociate == null) {
            return;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentModel sourceTemplate = this.documentManager.getDocument((DocumentRef)new IdRef(this.templateIdToAssociate));
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        try {
            currentDocument = tps.makeTemplateBasedDocument(currentDocument, sourceTemplate, true);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to do template association", (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.template.err.associationFailed"), new Object[]{sourceTemplate.getName()});
        }
        this.navigationContext.invalidateCurrentDocument();
        EventManager.raiseEventsOnDocumentChange((DocumentModel)currentDocument);
        this.templateIdToAssociate = null;
    }

    public boolean canRenderAndStore() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateBasedDocument template = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (template == null) {
            return false;
        }
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        return bh != null;
    }

    public String getEditableTemplateName() {
        return this.editableTemplateName;
    }

    public void setEditableTemplateName(String editableTemplateName) {
        if (editableTemplateName == null || !editableTemplateName.equals(this.editableTemplateName)) {
            this.editableTemplateName = editableTemplateName;
            this.templateEditableInputs = null;
        }
    }

    public List<TemplateSourceDocument> getBindableTemplatesForDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String targetType = currentDocument.getType();
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        List templates = tps.getAvailableTemplateDocs(this.documentManager, targetType);
        ArrayList<TemplateSourceDocument> result = new ArrayList<TemplateSourceDocument>();
        TemplateBasedDocument currentTBD = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        List alreadyBoundTemplateNames = new ArrayList();
        if (currentTBD != null) {
            alreadyBoundTemplateNames = currentTBD.getTemplateNames();
        }
        for (DocumentModel doc : templates) {
            TemplateSourceDocument source = (TemplateSourceDocument)doc.getAdapter(TemplateSourceDocument.class);
            if (alreadyBoundTemplateNames.contains(source.getName())) continue;
            result.add(source);
        }
        return result;
    }

    public List<SelectItem> getBindableTemplatesForDocumentAsSelectItems() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List<TemplateSourceDocument> sources = this.getBindableTemplatesForDocument();
        for (TemplateSourceDocument sd : sources) {
            DocumentModel doc = sd.getAdaptedDoc();
            String label = doc.getTitle();
            if (doc.isVersion()) {
                label = label + " (V " + doc.getVersionLabel() + ")";
            }
            items.add(new SelectItem((Object)doc.getId(), label));
        }
        return items;
    }

    public boolean canBindNewTemplate() throws Exception {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!currentDocument.getCoreSession().hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        return this.getBindableTemplatesForDocument().size() != 0;
    }

    @Factory(value="currentTemplateBasedDocument", scope=ScopeType.EVENT)
    public TemplateBasedDocument getCurrentDocumentAsTemplateBasedDocument() {
        return (TemplateBasedDocument)this.navigationContext.getCurrentDocument().getAdapter(TemplateBasedDocument.class);
    }

    @Factory(value="associatedRenderableTemplates", scope=ScopeType.EVENT)
    public List<TemplateSourceDocument> getRenderableTemplates() throws Exception {
        ArrayList<TemplateSourceDocument> result = new ArrayList<TemplateSourceDocument>();
        TemplateBasedDocument template = this.getCurrentDocumentAsTemplateBasedDocument();
        if (template != null) {
            List sources = template.getSourceTemplates();
            for (TemplateSourceDocument source : sources) {
                if (source.getTargetRenditionName() != null && !source.getTargetRenditionName().isEmpty()) continue;
                result.add(source);
            }
        }
        return result;
    }
}

