/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.parser.ASTJexlScript;

public class ExpressionImpl
implements Expression,
Script {
    protected final JexlEngine jexl;
    protected final String expression;
    protected final ASTJexlScript script;

    protected ExpressionImpl(JexlEngine engine, String expr, ASTJexlScript ref) {
        this.jexl = engine;
        this.expression = expr;
        this.script = ref;
    }

    public Object evaluate(JexlContext context) {
        if (this.script.jjtGetNumChildren() < 1) {
            return null;
        }
        Interpreter interpreter = this.jexl.createInterpreter(context);
        return interpreter.interpret(this.script.jjtGetChild(0));
    }

    public String dump() {
        Debugger debug = new Debugger();
        return debug.debug(this.script) ? debug.toString() : "/*?*/";
    }

    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        String expr = this.getExpression();
        return expr == null ? "" : expr;
    }

    public String getText() {
        return this.toString();
    }

    public Object execute(JexlContext context) {
        Interpreter interpreter = this.jexl.createInterpreter(context);
        return interpreter.interpret(this.script);
    }
}

