/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.xdocreport;

import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.fm.FMContextBuilder;
import org.nuxeo.template.fm.FreeMarkerVariableExtractor;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.xdocreport.XDocReportBindingResolver;
import org.nuxeo.template.processors.xdocreport.ZipXmlHelper;

public class XDocReportProcessor
extends AbstractTemplateProcessor
implements TemplateProcessor {
    protected static final Log log = LogFactory.getLog(XDocReportProcessor.class);
    public static final String TEMPLATE_TYPE = "XDocReport";
    public static final String OOO_TEMPLATE_TYPE = "OpenDocument";
    public static final String DocX_TEMPLATE_TYPE = "DocX";
    protected FMContextBuilder fmContextBuilder = new FMContextBuilder();

    protected String getTemplateFormat(Blob blob) {
        File file;
        String filename = blob.getFilename();
        if (filename == null && blob instanceof FileBlob && (file = ((FileBlob)blob).getFile()) != null) {
            filename = file.getName();
        }
        if (filename != null && !filename.isEmpty()) {
            if (filename.endsWith(".docx")) {
                return DocX_TEMPLATE_TYPE;
            }
            if (filename.endsWith(".odt")) {
                return OOO_TEMPLATE_TYPE;
            }
        }
        return OOO_TEMPLATE_TYPE;
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws Exception {
        ArrayList<TemplateInput> params = new ArrayList<TemplateInput>();
        String xmlContent = null;
        if (OOO_TEMPLATE_TYPE.equals(this.getTemplateFormat(blob))) {
            xmlContent = ZipXmlHelper.readXMLContent(blob, "content.xml");
        } else if (DocX_TEMPLATE_TYPE.equals(this.getTemplateFormat(blob))) {
            xmlContent = ZipXmlHelper.readXMLContent(blob, "word/document.xml");
        }
        if (xmlContent != null) {
            List vars = FreeMarkerVariableExtractor.extractVariables((String)xmlContent);
            for (String var : vars) {
                TemplateInput input = new TemplateInput(var);
                params.add(input);
            }
        }
        return params;
    }

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        IXDocReport report = XDocReportRegistry.getRegistry().loadReport(sourceTemplateBlob.getStream(), TemplateEngineKind.Freemarker, false);
        List params = templateBasedDocument.getParams(templateName);
        FieldsMetadata metadata = new FieldsMetadata();
        for (TemplateInput param : params) {
            if (param.getType() != InputType.PictureProperty) continue;
            metadata.addFieldAsImage(param.getName());
        }
        report.setFieldsMetadata(metadata);
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        Map ctx = this.fmContextBuilder.build(doc, templateName);
        XDocReportBindingResolver resolver = new XDocReportBindingResolver(metadata);
        resolver.resolve(params, ctx, templateBasedDocument);
        IContext context = report.createContext();
        for (String key : ctx.keySet()) {
            context.put(key, ctx.get(key));
        }
        metadata.addFieldAsList("auditEntries.principalName");
        metadata.addFieldAsList("auditEntries.eventId");
        metadata.addFieldAsList("auditEntries.eventDate");
        metadata.addFieldAsList("auditEntries.docUUID");
        metadata.addFieldAsList("auditEntries.docPath");
        metadata.addFieldAsList("auditEntries.docType");
        metadata.addFieldAsList("auditEntries.category");
        metadata.addFieldAsList("auditEntries.comment");
        metadata.addFieldAsList("auditEntries.docLifeCycle");
        metadata.addFieldAsList("auditEntries.repositoryId");
        File workingDir = this.getWorkingDir();
        File generated = new File(workingDir, "XDOCReportresult-" + System.currentTimeMillis());
        generated.createNewFile();
        FileOutputStream out = new FileOutputStream(generated);
        report.process(context, (OutputStream)out);
        Blob newBlob = Blobs.createBlob((File)generated);
        String templateFileName = sourceTemplateBlob.getFilename();
        String targetFileExt = FileUtils.getFileExtension((String)templateFileName);
        String targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        targetFileName = targetFileName + "." + targetFileExt;
        newBlob.setFilename(targetFileName);
        Framework.trackFile((File)generated, (Object)newBlob);
        return newBlob;
    }
}

