/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.xdocreport.jaxrs;

import fr.opensagres.xdocreport.remoting.resources.domain.BinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Filter;
import fr.opensagres.xdocreport.remoting.resources.domain.LargeBinaryData;
import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import fr.opensagres.xdocreport.remoting.resources.domain.ResourceType;
import fr.opensagres.xdocreport.remoting.resources.services.ResourcesException;
import fr.opensagres.xdocreport.remoting.resources.services.jaxrs.JAXRSResourcesService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.JsonHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.processors.xdocreport.FieldDefinitionGenerator;
import org.nuxeo.template.xdocreport.jaxrs.AbstractResourceService;
import org.nuxeo.template.xdocreport.jaxrs.BinaryDataWrapper;
import org.nuxeo.template.xdocreport.jaxrs.NonRecursiveResource;
import org.nuxeo.template.xdocreport.jaxrs.ResourceWrapper;

public class XDocReportResourceService
extends AbstractResourceService
implements JAXRSResourcesService {
    protected static final Log log = LogFactory.getLog(XDocReportResourceService.class);

    public XDocReportResourceService(CoreSession session) {
        super(session);
    }

    public List<BinaryData> download(List<String> resourcePaths) {
        return null;
    }

    public String getName() {
        return "Nuxeo-Repository";
    }

    public Resource getRoot() {
        NonRecursiveResource root = new NonRecursiveResource();
        root.setType(ResourceType.CATEGORY);
        root.setName("Nuxeo");
        root.setId("nuxeo");
        ArrayList<Resource> children = new ArrayList<Resource>();
        List<TemplateSourceDocument> templates = this.getTemplates();
        for (TemplateSourceDocument template : templates) {
            children.add(ResourceWrapper.wrap(template));
        }
        root.getChildren().addAll(children);
        return root;
    }

    @GET
    @Path(value="model/list")
    public String listModels() throws Exception {
        SchemaManager sm = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DocumentType[] docTypes = sm.getDocumentTypes();
        ArrayList<String> names = new ArrayList<String>();
        for (DocumentType dt : docTypes) {
            names.add(dt.getName());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonGenerator gen = JsonHelper.createJsonGenerator((OutputStream)out);
        gen.writeObject(names);
        return out.toString();
    }

    @GET
    @Path(value="model/{type}")
    public String getFieldDefinition(@PathParam(value="type") String type) {
        try {
            return FieldDefinitionGenerator.generate(type);
        }
        catch (Exception e) {
            log.error((Object)"Error during field xml definition generation", (Throwable)e);
            return e.getMessage();
        }
    }

    public void upload(BinaryData dataIn) {
        String id = dataIn.getResourceId();
        if (id != null) {
            IdRef ref = new IdRef(id);
            try {
                DocumentModel target = this.session.getDocument((DocumentRef)ref);
                TemplateSourceDocument template = (TemplateSourceDocument)target.getAdapter(TemplateSourceDocument.class);
                if (template != null) {
                    Blob oldBlob = template.getTemplateBlob();
                    Blob newBlob = Blobs.createBlob((byte[])dataIn.getContent(), (String)oldBlob.getMimeType());
                    newBlob.setFilename(oldBlob.getFilename());
                    template.setTemplateBlob(newBlob, true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error during template upload", (Throwable)e);
            }
        }
    }

    public List<BinaryData> downloadMultiple(List<String> arg0) throws ResourcesException {
        return null;
    }

    public Resource getRootWithFilter(Filter filter) throws ResourcesException {
        return this.getRoot();
    }

    public LargeBinaryData downloadLarge(String resourcePath) throws ResourcesException {
        CoreSession session = this.getCoreSession();
        try {
            if (resourcePath.endsWith(".fields.xml")) {
                String uuid = resourcePath.replace(".fields.xml", "");
                DocumentModel targetDoc = session.getDocument((DocumentRef)new IdRef(uuid));
                TemplateSourceDocument template = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
                List types = template.getApplicableTypes();
                String targetType = "File";
                if (types.size() > 0) {
                    targetType = (String)types.get(0);
                }
                String xml = FieldDefinitionGenerator.generate(targetType);
                return BinaryDataWrapper.wrapXml(xml, resourcePath);
            }
            String uuid = resourcePath;
            DocumentModel targetDoc = session.getDocument((DocumentRef)new IdRef(uuid));
            TemplateSourceDocument template = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
            return BinaryDataWrapper.wrap(template);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BinaryData download(String resourcePath) {
        return null;
    }

    public void uploadLarge(LargeBinaryData dataIn) throws ResourcesException {
        String id = dataIn.getResourceId();
        if (id != null) {
            IdRef ref = new IdRef(id);
            try {
                DocumentModel target = this.session.getDocument((DocumentRef)ref);
                TemplateSourceDocument template = (TemplateSourceDocument)target.getAdapter(TemplateSourceDocument.class);
                if (template != null) {
                    Blob oldBlob = template.getTemplateBlob();
                    Blob newBlob = Blobs.createBlob((InputStream)dataIn.getContent(), (String)oldBlob.getMimeType());
                    newBlob.setFilename(oldBlob.getFilename());
                    template.setTemplateBlob(newBlob, true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error during template upload", (Throwable)e);
            }
        }
    }
}

