/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.importer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.AbstractDocumentReader;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class XMLModelReader
extends AbstractDocumentReader {
    protected File source;
    protected boolean done;
    protected String modelName;

    public XMLModelReader(File source, String modelName) {
        this.source = source;
        this.done = false;
        this.modelName = modelName;
    }

    public void close() {
        this.source = null;
    }

    public ExportedDocument read() throws IOException {
        if (this.done) {
            return null;
        }
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        for (File file : this.source.listFiles()) {
            if (!file.isFile()) continue;
            String name = file.getName();
            if ("document.xml".equals(name)) {
                Document doc = XMLModelReader.loadXML(file);
                xdoc.setDocument(doc);
                xdoc.setPath(new Path(this.modelName));
                continue;
            }
            xdoc.putBlob(file.getName(), (Blob)new StreamingBlob((StreamSource)new FileSource(file)));
        }
        this.done = true;
        return xdoc;
    }

    private static Document loadXML(File file) throws IOException {
        try (BufferedInputStream in = null;){
            in = new BufferedInputStream(new FileInputStream(file));
            Document document = new SAXReader().read((InputStream)in);
            return document;
        }
    }
}

