/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.jxls;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jxls.transformer.XLSTransformer;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.context.SimpleContextBuilder;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.jxls.JXLSBindingResolver;

public class JXLSTemplateProcessor
extends AbstractTemplateProcessor {
    public static final String TEMPLATE_TYPE = "JXLS";
    protected SimpleContextBuilder contextBuilder = new SimpleContextBuilder();

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        List params = templateBasedDocument.getParams(templateName);
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        Map ctx = this.contextBuilder.build(doc, templateName);
        JXLSBindingResolver resolver = new JXLSBindingResolver();
        resolver.resolve(params, ctx, templateBasedDocument);
        File workingDir = this.getWorkingDir();
        File generated = new File(workingDir, "JXLSresult-" + System.currentTimeMillis());
        generated.createNewFile();
        File input = new File(workingDir, "JXLSInput-" + System.currentTimeMillis());
        input.createNewFile();
        sourceTemplateBlob.transferTo(input);
        XLSTransformer transformer = new XLSTransformer();
        this.configureTransformer(transformer);
        transformer.transformXLS(input.getAbsolutePath(), ctx, generated.getAbsolutePath());
        input.delete();
        FileBlob newBlob = new FileBlob(generated);
        String templateFileName = sourceTemplateBlob.getFilename();
        String targetFileExt = FileUtils.getFileExtension((String)templateFileName);
        String targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        targetFileName = targetFileName + "." + targetFileExt;
        newBlob.setFilename(targetFileName);
        Framework.trackFile((File)generated, (Object)newBlob);
        return newBlob;
    }

    protected void configureTransformer(XLSTransformer transformer) {
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws Exception {
        return new ArrayList<TemplateInput>();
    }
}

