/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet.config;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.wss.fprpc.FPRPCConts;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;
import org.nuxeo.wss.servlet.config.LRUCachingMap;
import org.nuxeo.wss.servlet.config.XmlConfigHandler;

public class FilterBindingResolver {
    protected static final Map<String, FilterBindingConfig> bindingCache = new LRUCachingMap<String, FilterBindingConfig>(50);

    public static FilterBindingConfig getBinding(HttpServletRequest request) throws Exception {
        String UA = request.getHeader("User-Agent");
        if (FPRPCConts.MSOFFICE_USERAGENT.equals(UA)) {
            FilterBindingConfig config = new FilterBindingConfig();
            config.setRequestType("GET");
            config.setTargetService("VtiHandler");
            return config;
        }
        String uri = request.getRequestURI();
        return FilterBindingResolver.getBinding(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FilterBindingConfig getBinding(String uri) throws Exception {
        FilterBindingConfig binding;
        Map<String, FilterBindingConfig> map = bindingCache;
        synchronized (map) {
            binding = bindingCache.get(uri);
        }
        if (binding == null) {
            binding = FilterBindingResolver.computeBindingForRequest(uri);
            map = bindingCache;
            synchronized (map) {
                bindingCache.put(uri, binding);
            }
        }
        return binding;
    }

    protected static synchronized FilterBindingConfig computeBindingForRequest(String uri) throws Exception {
        List<FilterBindingConfig> bindings = XmlConfigHandler.getConfigEntries();
        for (FilterBindingConfig binding : bindings) {
            Pattern pat = binding.getUrlPattern();
            Matcher m = pat.matcher(uri);
            if (!m.matches()) continue;
            if (m.groupCount() > 0) {
                String site = m.group(1);
                return new FilterBindingConfig(binding, site);
            }
            return binding;
        }
        return null;
    }
}

