/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.images;

import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.document.images.AbstractImageRegistry;
import fr.opensagres.xdocreport.document.images.ImageProviderInfo;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;

public class ODTImageRegistry
extends AbstractImageRegistry {
    private static final String POINT_UNIT = "pt";
    private static final String IMAGE_BASE_PATH = "Pictures/";

    public ODTImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider, FieldsMetadata fieldsMetadata) {
        super(readerProvider, writerProvider, outputStreamProvider, fieldsMetadata);
    }

    protected String getImageBasePath() {
        return IMAGE_BASE_PATH;
    }

    protected String getPath(ImageProviderInfo info) {
        return info.getImageBasePath() + info.getImageFileName();
    }

    protected String getSize(float sizeAsPixel) {
        float sizeAsPoint = sizeAsPixel * 0.75f;
        String s = Float.toString(sizeAsPoint);
        int dotindex = s.indexOf(46);
        if (dotindex != -1) {
            return s.substring(0, dotindex) + POINT_UNIT;
        }
        return s + POINT_UNIT;
    }
}

