/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.ConnectServerResponse;

public class ConnectHttpResponse
implements ConnectServerResponse {
    protected static final Log log = LogFactory.getLog(ConnectHttpResponse.class);
    protected HttpClient httpClient;
    protected HttpMethod method;

    public ConnectHttpResponse(HttpClient httpClient, HttpMethod method) {
        this.httpClient = httpClient;
        this.method = method;
    }

    @Override
    public InputStream getInputStream() throws ConnectServerError {
        try {
            return this.method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new ConnectServerError("Unable to get Stream", e);
        }
    }

    @Override
    public String getString() throws ConnectServerError {
        try {
            return this.method.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new ConnectServerError("Unable to ready body", e);
        }
    }

    @Override
    public void release() {
        this.method.releaseConnection();
    }
}

